/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.client;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.transport.Writer;
import java.util.Timer;
import java.util.TimerTask;

public class FramebufferUpdateRequestMessage
implements ClientToServerMessage {
    private final int height;
    private final int width;
    private final int y;
    private final int x;
    private boolean sendFullScreenFlag;

    public FramebufferUpdateRequestMessage(int x, int y, int width, int height, boolean fullScreen) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.sendFullScreenFlag = fullScreen;
    }

    @Override
    public void send(Writer writer) throws TransportException {
        writer.writeByte(3);
        if (this.sendFullScreenFlag) {
            writer.writeByte(0);
            this.sendFullScreenFlag = false;
        } else {
            writer.writeByte(1);
        }
        writer.writeInt16(this.x);
        writer.writeInt16(this.y);
        writer.writeInt16(this.width);
        writer.writeInt16(this.height);
        writer.flush();
    }

    public String toString() {
        return "FramebufferUpdateRequestMessage: [x: " + this.x + " y: " + this.y + " width: " + this.width + " height: " + this.height + " fullScreen: " + this.sendFullScreenFlag + "]";
    }

    public void sendFullScreenRequest() {
        int sendFullScreenTimer = 50000;
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                FramebufferUpdateRequestMessage.this.sendFullScreenFlag = true;
            }
        };
        Timer timer = new Timer();
        timer.schedule(tt, 0L, (long)sendFullScreenTimer);
    }
}

