/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.transport.Reader;

public class ServerInitMessage {
    protected int frameBufferWidth;
    protected int frameBufferHeight;
    protected PixelFormat pixelFormat;
    protected String name;
    protected byte[] initData;

    public ServerInitMessage(Reader reader) throws TransportException {
        this.readServerInit(reader);
        this.frameBufferWidth = reader.readUInt16();
        this.frameBufferHeight = reader.readUInt16();
        this.pixelFormat = new PixelFormat();
        this.pixelFormat.fill(reader);
        this.name = reader.readString();
    }

    protected ServerInitMessage() {
    }

    public int getFrameBufferWidth() {
        return this.frameBufferWidth;
    }

    public int getFrameBufferHeight() {
        return this.frameBufferHeight;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public byte[] getInitData() {
        return this.initData;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ServerInitMessage: [name: " + this.name + ", framebuffer-width: " + String.valueOf(this.frameBufferWidth) + ", framebuffer-height: " + String.valueOf(this.frameBufferHeight) + ", server-pixel-format: " + this.pixelFormat + "]";
    }

    public void readServerInit(Reader reader) throws TransportException {
        reader.mark(255);
        reader.skipBytes(20);
        int nlen = reader.readInt32();
        int blen = 24 + nlen;
        this.initData = new byte[blen];
        reader.reset();
        reader.mark(blen);
        reader.readBytes(this.initData);
        reader.reset();
    }
}

