/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.decoder.CopyRectDecoder;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.HextileDecoder;
import com.glavsoft.rfb.encoding.decoder.RREDecoder;
import com.glavsoft.rfb.encoding.decoder.RawDecoder;
import com.glavsoft.rfb.encoding.decoder.TightDecoder;
import com.glavsoft.rfb.encoding.decoder.ZRLEDecoder;
import com.glavsoft.rfb.encoding.decoder.ZlibDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DecodersContainer {
    private static Map<EncodingType, Class<? extends Decoder>> knownDecoders = new HashMap<EncodingType, Class<? extends Decoder>>();
    private final Map<EncodingType, Decoder> decoders = new HashMap<EncodingType, Decoder>();

    public DecodersContainer() {
        this.decoders.put(EncodingType.RAW_ENCODING, RawDecoder.getInstance());
    }

    public void instantiateDecodersWhenNeeded(Collection<EncodingType> encodings) {
        for (EncodingType enc : encodings) {
            if (!EncodingType.ordinaryEncodings.contains((Object)enc) || this.decoders.containsKey((Object)enc)) continue;
            try {
                this.decoders.put(enc, knownDecoders.get((Object)enc).newInstance());
            }
            catch (InstantiationException e) {
                this.logError(enc, e);
                System.out.println("cannot create decoders instance.");
            }
            catch (IllegalAccessException e) {
                this.logError(enc, e);
                System.out.println("cannot access class or constructor.");
            }
        }
    }

    private void logError(EncodingType enc, Exception e) {
        Logger.getLogger(this.getClass().getName()).severe("Cannot instantiate decoder for encoding type '" + enc.getName() + "' " + e.getMessage());
    }

    public Decoder getDecoderByType(EncodingType type) {
        return this.decoders.get((Object)type);
    }

    public void setDecoderByType(EncodingType type, Decoder decoder) {
        this.decoders.put(type, decoder);
    }

    public void resetDecoders() {
        for (Decoder decoder : this.decoders.values()) {
            if (decoder == null) continue;
            decoder.reset();
        }
    }

    static {
        knownDecoders.put(EncodingType.TIGHT, TightDecoder.class);
        knownDecoders.put(EncodingType.HEXTILE, HextileDecoder.class);
        knownDecoders.put(EncodingType.ZRLE, ZRLEDecoder.class);
        knownDecoders.put(EncodingType.ZLIB, ZlibDecoder.class);
        knownDecoders.put(EncodingType.RRE, RREDecoder.class);
        knownDecoders.put(EncodingType.COPY_RECT, CopyRectDecoder.class);
        knownDecoders.put(EncodingType.ZRLEE, ZRLEDecoder.class);
    }
}

