/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.transport.Reader;
import java.io.UnsupportedEncodingException;

public class FramebufferUpdateRectangle {
    public int x;
    public int y;
    public int width;
    public int height;
    private EncodingType encodingType;
    public long time;
    public int port;

    public FramebufferUpdateRectangle() {
    }

    public FramebufferUpdateRectangle(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void fill(Reader reader) throws TransportException, UnsupportedEncodingException {
        this.x = reader.readInt16();
        this.y = reader.readInt16();
        this.width = reader.readUInt16();
        this.height = reader.readUInt16();
        int encoding = reader.readInt32();
        this.encodingType = EncodingType.byId(encoding);
        if (encoding == EncodingType.CHECK_DELAY.getId()) {
            this.time = reader.readInt64();
        }
    }

    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public String toString() {
        return "FramebufferUpdateRect: [x: " + this.x + ", y: " + this.y + ", width: " + this.width + ", height: " + this.height + ", encodingType: " + (Object)((Object)this.encodingType) + "]";
    }
}

