/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.encoding.decoder.ZRLEDecoder;
import com.glavsoft.transport.Reader;
import java.io.UnsupportedEncodingException;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class ZRLEESender
extends Decoder {
    private TreeRFBProto rfb;

    public ZRLEESender(TreeRFBProto rfb) {
        this.rfb = rfb;
    }

    public ZRLEESender() {
    }

    @Override
    public void decode(Reader reader, Renderer renderer, FramebufferUpdateRectangle rect) throws TransportException, UnsupportedEncodingException {
        int dataLen = this.getZrleLength(rect, reader);
        byte[] bytes = new byte[rect.width * rect.height * renderer.getBytesPerPixel()];
        reader.reset();
        if (this.rfb.hasViewer()) {
            ZRLEDecoder decoder = new ZRLEDecoder();
            if (rect.getEncodingType() == EncodingType.ZRLE) {
                this.rfb.readSendData(dataLen, reader, bytes, rect);
                decoder.decode1(renderer, rect, bytes, 0);
                return;
            }
            this.rfb.readSendData(dataLen, reader, null, rect);
            reader.reset();
            if (rect.getEncodingType() == EncodingType.CHECK_DELAY) {
                reader.skip(24);
            } else {
                reader.skip(16);
            }
            decoder.decode(reader, renderer, rect);
            return;
        }
        this.rfb.readSendData(dataLen, reader, bytes, rect);
    }

    private int getZrleLength(FramebufferUpdateRectangle rect, Reader reader) throws TransportException {
        int zrleLength = 0;
        if (rect.getEncodingType() == EncodingType.ZRLE || rect.getEncodingType() == EncodingType.ZRLEE || rect.getEncodingType() == EncodingType.ZLIB || rect.getEncodingType() == EncodingType.CHECK_DELAY) {
            zrleLength = reader.readInt32();
        }
        if (rect.getEncodingType() == EncodingType.CHECK_DELAY) {
            return zrleLength + 20 + 8;
        }
        return zrleLength + 20;
    }
}

