/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.ClipboardController;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.rfb.IPasswordRetriever;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.IRfbSessionListener;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.client.SetEncodingsMessage;
import com.glavsoft.rfb.client.SetPixelFormatMessage;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.DecodersContainer;
import com.glavsoft.rfb.protocol.MessageQueue;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.rfb.protocol.ReceiverTask;
import com.glavsoft.rfb.protocol.SenderTask;
import com.glavsoft.rfb.protocol.state.HandshakeState;
import com.glavsoft.rfb.protocol.state.ProtocolState;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import java.util.logging.Logger;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class Protocol
implements ProtocolContext,
IChangeSettingsListener {
    private ProtocolState state;
    private final Logger logger;
    private final IPasswordRetriever passwordRetriever;
    private final ProtocolSettings settings;
    private int fbWidth;
    private int fbHeight;
    private PixelFormat pixelFormat;
    private final Reader reader;
    private final Writer writer;
    private String remoteDesktopName;
    private MessageQueue messageQueue;
    private final DecodersContainer decoders;
    private SenderTask senderTask;
    private ReceiverTask receiverTask;
    private IRfbSessionListener rfbSessionListener;
    private IRepaintController repaintController;
    private PixelFormat serverPixelFormat;
    private Thread senderThread;
    private Thread receiverThread;
    private boolean isTight;
    private String protocolVersion;
    private byte[] initData;
    private TreeRFBProto rfb;

    public Protocol(Reader reader, Writer writer, IPasswordRetriever passwordRetriever, ProtocolSettings settings, TreeRFBProto myRfb) {
        this.reader = reader;
        this.writer = writer;
        this.passwordRetriever = passwordRetriever;
        this.settings = settings;
        this.decoders = new DecodersContainer();
        this.decoders.instantiateDecodersWhenNeeded(settings.encodings);
        this.state = new HandshakeState(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.rfb = myRfb;
    }

    @Override
    public void changeStateTo(ProtocolState state) {
        this.state = state;
    }

    public void handshake() throws UnsupportedProtocolVersionException, UnsupportedSecurityTypeException, AuthenticationFailedException, TransportException, FatalException {
        while (this.state.next()) {
        }
        this.messageQueue = new MessageQueue();
    }

    @Override
    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    @Override
    public void setPixelFormat(PixelFormat pixelFormat) {
        this.pixelFormat = pixelFormat;
        if (this.repaintController != null) {
            this.repaintController.setPixelFormat(pixelFormat);
        }
    }

    @Override
    public String getRemoteDesktopName() {
        return this.remoteDesktopName;
    }

    @Override
    public void setRemoteDesktopName(String name) {
        this.remoteDesktopName = name;
    }

    @Override
    public int getFbWidth() {
        return this.fbWidth;
    }

    @Override
    public void setFbWidth(int fbWidth) {
        this.fbWidth = fbWidth;
    }

    @Override
    public int getFbHeight() {
        return this.fbHeight;
    }

    @Override
    public byte[] getInitData() {
        return this.initData;
    }

    @Override
    public void setInitData(byte[] initData) {
        this.initData = initData;
    }

    @Override
    public void setFbHeight(int fbHeight) {
        this.fbHeight = fbHeight;
    }

    @Override
    public IPasswordRetriever getPasswordRetriever() {
        return this.passwordRetriever;
    }

    @Override
    public ProtocolSettings getSettings() {
        return this.settings;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    public void startNormalHandling(IRfbSessionListener rfbSessionListener, IRepaintController repaintController, ClipboardController clipboardController, TreeRFBProto rfb) {
        this.receiverTask = new ReceiverTask(this.reader, repaintController, clipboardController, this.decoders, this, rfb);
        this.startNormalHandling1(rfbSessionListener, repaintController, clipboardController);
    }

    public void startNormalHandling1(IRfbSessionListener rfbSessionListener, IRepaintController repaintController, ClipboardController clipboardController) {
        this.rfbSessionListener = rfbSessionListener;
        this.repaintController = repaintController;
        this.serverPixelFormat = this.pixelFormat;
        this.correctServerPixelFormat();
        this.setPixelFormat(this.createPixelFormat(this.settings));
        this.sendMessage(new SetPixelFormatMessage(this.pixelFormat));
        this.logger.fine("sent: " + this.pixelFormat);
        this.sendSupportedEncodingsMessage(this.settings);
        this.settings.addListener(this);
        this.settings.addListener(repaintController);
        this.senderTask = new SenderTask(this.messageQueue, this.writer, this);
        this.senderThread = new Thread((Runnable)this.senderTask, "RfbSenderTask");
        this.senderThread.start();
        this.decoders.resetDecoders();
        this.receiverThread = new Thread((Runnable)this.receiverTask, "RfbReceiverTask");
        this.receiverThread.start();
    }

    private void correctServerPixelFormat() {
        this.serverPixelFormat.trueColourFlag = 1;
        long significant = this.serverPixelFormat.redMax << this.serverPixelFormat.redShift | this.serverPixelFormat.greenMax << this.serverPixelFormat.greenShift | this.serverPixelFormat.blueMax << this.serverPixelFormat.blueShift;
        if (32 == this.serverPixelFormat.bitsPerPixel && ((significant & 0xFF000000L) == 0L || (significant & 0xFFL) == 0L) && 32 == this.serverPixelFormat.depth) {
            this.serverPixelFormat.depth = (byte)24;
        }
    }

    @Override
    public void sendMessage(ClientToServerMessage message) {
        this.messageQueue.put(message);
    }

    private void sendSupportedEncodingsMessage(ProtocolSettings settings) {
        this.decoders.instantiateDecodersWhenNeeded(settings.encodings);
        SetEncodingsMessage encodingsMessage = new SetEncodingsMessage(settings.encodings);
        this.sendMessage(encodingsMessage);
        this.logger.fine("sent: " + encodingsMessage.toString());
    }

    private PixelFormat createPixelFormat(ProtocolSettings settings) {
        byte serverBigEndianFlag = this.serverPixelFormat.bigEndianFlag;
        switch (settings.getColorDepth()) {
            case 24: {
                return PixelFormat.create24bitColorDepthPixelFormat(serverBigEndianFlag);
            }
            case 16: {
                return PixelFormat.create16bitColorDepthPixelFormat(serverBigEndianFlag);
            }
            case 8: {
                return PixelFormat.create8bitColorDepthBGRPixelFormat(serverBigEndianFlag);
            }
            case 6: {
                return PixelFormat.create6bitColorDepthPixelFormat(serverBigEndianFlag);
            }
            case 3: {
                return PixelFormat.create3bppPixelFormat(serverBigEndianFlag);
            }
            case 0: {
                return this.serverPixelFormat;
            }
        }
        return PixelFormat.create24bitColorDepthPixelFormat(serverBigEndianFlag);
    }

    @Override
    public void settingsChanged(SettingsChangedEvent e) {
        ProtocolSettings settings = (ProtocolSettings)e.getSource();
        if (settings.isChangedEncodings()) {
            this.sendSupportedEncodingsMessage(settings);
        }
        if (settings.isChangedColorDepth() && this.receiverTask != null) {
            this.receiverTask.queueUpdatePixelFormat(this.createPixelFormat(settings));
        }
    }

    @Override
    public void sendRefreshMessage() {
        if (this.receiverTask != null) {
            this.sendMessage(this.receiverTask.fullscreenFbUpdateIncrementalRequest);
            this.logger.fine("sent: full FB Refresh");
        }
    }

    @Override
    public void cleanUpSession(String message) {
        this.cleanUpSession();
        if (message != null) {
            this.rfbSessionListener.rfbSessionStopped(message);
        }
    }

    public synchronized void cleanUpSession() {
        if (this.senderTask != null) {
            this.senderTask.stopTask();
            try {
                this.senderThread.join();
            }
            catch (InterruptedException e) {
                System.out.println("any thread has interrupted the current thread");
            }
            this.senderTask = null;
        }
        this.stopReceiverTask();
    }

    @Override
    public void stopReceiverTask() {
        if (this.receiverTask != null) {
            this.receiverTask.stopTask();
            try {
                this.receiverThread.join();
            }
            catch (InterruptedException e) {
                System.out.println("any thread has interrupted the current thread");
            }
            this.receiverTask = null;
        }
    }

    @Override
    public int getNumberOfRectangle() {
        return this.receiverTask.numberOfRectangles;
    }

    @Override
    public TreeRFBProto getRfb() {
        return this.rfb;
    }

    @Override
    public void setTight(boolean isTight) {
        this.isTight = isTight;
    }

    @Override
    public boolean isTight() {
        return this.isTight;
    }

    @Override
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void resetDecoder() {
        this.decoders.resetDecoders();
    }
}

