/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.rfb.IPasswordRetriever;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.rfb.protocol.state.ProtocolState;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public interface ProtocolContext {
    public static final int MAX_UNIQUE_NODE_ID = 20000;
    public static final int MAX_RANDAM_NODE_ID = 30000;

    public void changeStateTo(ProtocolState var1);

    public IPasswordRetriever getPasswordRetriever();

    public ProtocolSettings getSettings();

    public Writer getWriter();

    public Reader getReader();

    public byte[] getInitData();

    public int getFbWidth();

    public void setFbWidth(int var1);

    public int getFbHeight();

    public void setFbHeight(int var1);

    public PixelFormat getPixelFormat();

    public void setPixelFormat(PixelFormat var1);

    public void setRemoteDesktopName(String var1);

    public void sendMessage(ClientToServerMessage var1);

    public String getRemoteDesktopName();

    public void sendRefreshMessage();

    public void cleanUpSession(String var1);

    public void setTight(boolean var1);

    public boolean isTight();

    public void setProtocolVersion(String var1);

    public String getProtocolVersion();

    public void setInitData(byte[] var1);

    public void resetDecoder();

    public void stopReceiverTask();

    public int getNumberOfRectangle();

    public TreeRFBProto getRfb();

    public static enum TreeCommand {
        FIND_ROOT(220),
        FIND_ROOT_REPLY(221),
        WHERE_TO_CONNECT(222),
        CONNECT_TO(223),
        CONNECT_TO_AS_LEADER(224),
        LOST_PARENT(225),
        NOT_FOUND_PARENT(226),
        NEW_NODE(227),
        QUIT_LOOP(228),
        LOST_CHILD(229);

        public final int cmd;

        private TreeCommand(int cmd) {
            this.cmd = cmd;
        }

        public static TreeCommand create(int i) {
            switch (i) {
                case 220: {
                    return FIND_ROOT;
                }
                case 221: {
                    return FIND_ROOT_REPLY;
                }
                case 222: {
                    return WHERE_TO_CONNECT;
                }
                case 223: {
                    return CONNECT_TO;
                }
                case 224: {
                    return CONNECT_TO_AS_LEADER;
                }
                case 225: {
                    return LOST_PARENT;
                }
                case 226: {
                    return NOT_FOUND_PARENT;
                }
                case 227: {
                    return NEW_NODE;
                }
                case 228: {
                    return QUIT_LOOP;
                }
            }
            return LOST_CHILD;
        }
    }
}

