/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.CommonException;
import com.glavsoft.exceptions.ProtocolException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.ClipboardController;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.client.FramebufferUpdateRequestMessage;
import com.glavsoft.rfb.client.SetPixelFormatMessage;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.DecodersContainer;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.encoding.decoder.RichCursorDecoder;
import com.glavsoft.rfb.encoding.decoder.ZRLEESender;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.transport.Reader;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.ViewerInterface;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.Timer;
import java.util.logging.Logger;
import jp.ac.u_ryukyu.treevnc.CheckDelayReply;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class ReceiverTask
implements Runnable {
    private static final byte FRAMEBUFFER_UPDATE = 0;
    private static final byte SET_COLOR_MAP_ENTRIES = 1;
    private static final byte BELL = 2;
    private static final byte SERVER_CUT_TEXT = 3;
    private static Logger logger = Logger.getLogger("com.glavsoft.rfb.protocol.ReceiverTask");
    private Reader reader;
    private volatile boolean isRunning = false;
    private Renderer renderer;
    private final IRepaintController repaintController;
    private final ClipboardController clipboardController;
    protected final DecodersContainer decoders;
    protected FramebufferUpdateRequestMessage fullscreenFbUpdateIncrementalRequest;
    protected final ProtocolContext context;
    protected PixelFormat pixelFormat;
    protected boolean needSendPixelFormat;
    private TreeRFBProto rfb;
    private long checkCounter = 0L;
    public int numberOfRectangles = 0;
    private Timer timer = null;

    public ReceiverTask(Reader reader, IRepaintController repaintController, ClipboardController clipboardController, DecodersContainer decoders, ProtocolContext context, TreeRFBProto _rfb) {
        this.rfb = _rfb;
        this.reader = reader;
        this.repaintController = repaintController;
        this.clipboardController = clipboardController;
        this.context = context;
        this.decoders = decoders;
        ZRLEESender decoder = new ZRLEESender(this.rfb);
        decoders.setDecoderByType(EncodingType.ZLIB, decoder);
        decoders.setDecoderByType(EncodingType.ZRLE, decoder);
        decoders.setDecoderByType(EncodingType.ZRLEE, decoder);
        if (this.rfb.fixingSize) {
            context.setFbWidth(this.rfb.fixingSizeWidth);
            context.setFbHeight(this.rfb.fixingSizeHeight);
        }
        ConnectionPresenter cp = this.rfb.getViewer().getConnectionPresenter();
        if (!this.rfb.getCuiVersion()) {
            if (cp.getSingleWidth() == 0) {
                cp.setSingleWidth(context.getFbWidth());
                cp.setSingleHeight(context.getFbHeight());
            }
            this.renderer = repaintController.createRenderer(reader, context.getFbWidth(), context.getFbHeight(), context.getPixelFormat());
        }
        if (this.rfb.isTreeManager()) {
            this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(cp.getX(), cp.getY(), cp.getSingleWidth(), cp.getSingleHeight(), false);
            this.fullscreenFbUpdateIncrementalRequest.sendFullScreenRequest();
            this.connectionFinished();
        }
    }

    @Override
    public void run() {
        this.isRunning = true;
        block15: while (this.isRunning) {
            try {
                this.reader.available();
                if (!this.isRunning) {
                    return;
                }
                if (!this.rfb.isTreeManager() && this.rfb.isAddSerialNum()) {
                    this.reader.mark(32);
                    this.getLost(this.reader);
                } else {
                    this.reader.mark(24);
                }
                byte messageId = this.reader.readByte();
                switch (messageId) {
                    case 0: {
                        this.framebufferUpdateMessage();
                        continue block15;
                    }
                    case 1: {
                        logger.severe("Server message SetColorMapEntries is not implemented. Skip.");
                        this.setColorMapEntries();
                        continue block15;
                    }
                    case 2: {
                        logger.fine("Server message: Bell");
                        continue block15;
                    }
                    case 3: {
                        logger.fine("Server message: CutText (3)");
                        this.serverCutText();
                        continue block15;
                    }
                }
                logger.severe("Unsupported server message. Id = " + messageId);
            }
            catch (TransportException e) {
                if (e.getCause().getClass().getSimpleName().equals("SocketTimeoutException")) {
                    if (this.rfb.isTreeManager()) {
                        this.sendFrameBufferUpdateRequest();
                    }
                    try {
                        this.reader.reset();
                    }
                    catch (TransportException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                logger.severe("Close session : ReceiverTask : " + e.getMessage());
                if (!this.rfb.isTreeManager() && !this.rfb.getTerminationType()) {
                    System.out.println("death parent node, wait connect new parent node.");
                    ViewerInterface viewer = this.rfb.getViewer();
                    viewer.setVisible(false);
                    try {
                        this.reader.close();
                    }
                    catch (TransportException e1) {
                        e1.printStackTrace();
                    }
                }
                this.stopTask();
            }
            catch (ProtocolException e) {
                logger.severe(e.getMessage());
                if (this.isRunning) {
                    this.context.cleanUpSession(e.getMessage() + "\nConnection closed.");
                }
                this.stopTask();
            }
            catch (CommonException e) {
                logger.severe(e.getMessage());
                if (this.isRunning) {
                    this.context.cleanUpSession("Connection closed..");
                }
                this.stopTask();
            }
            catch (Throwable te) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                te.printStackTrace(pw);
                logger.severe("updateRectangle record failed : " + te.getMessage());
                if (this.isRunning) {
                    this.context.cleanUpSession(te.getMessage() + "\n" + sw.toString());
                }
                this.stopTask();
            }
        }
    }

    private void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setColorMapEntries() throws TransportException {
        this.reader.readByte();
        this.reader.readUInt16();
        int length = this.reader.readUInt16();
        while (length-- > 0) {
            this.reader.readUInt16();
            this.reader.readUInt16();
            this.reader.readUInt16();
        }
    }

    private void serverCutText() throws TransportException {
        this.reader.readByte();
        this.reader.readInt16();
        int length = this.reader.readInt32() & Integer.MAX_VALUE;
        this.clipboardController.updateSystemClipboard(this.reader.readBytes(length));
    }

    public void framebufferUpdateMessage() throws Exception {
        try {
            this.reader.readByte();
            this.numberOfRectangles = this.reader.readUInt16();
            if (this.numberOfRectangles != 1) {
                System.out.println("numberofrectangle : " + this.numberOfRectangles);
            }
            while (this.numberOfRectangles-- > 0) {
                FramebufferUpdateRectangle rect = new FramebufferUpdateRectangle();
                rect.fill(this.reader);
                Decoder decoder = this.decoders.getDecoderByType(rect.getEncodingType());
                logger.finest(rect.toString() + (0 == this.numberOfRectangles ? "\n---" : ""));
                if (decoder != null) {
                    decoder.decode(this.reader, this.renderer, rect);
                    if (this.rfb.getCuiVersion()) continue;
                    this.repaintController.repaintBitmap(rect);
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.RICH_CURSOR) {
                    RichCursorDecoder.getInstance().decode(this.reader, this.renderer, rect);
                    if (this.repaintController == null) continue;
                    this.repaintController.repaintCursor();
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.CURSOR_POS) {
                    this.renderer.decodeCursorPosition(rect);
                    this.repaintController.repaintCursor();
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.EXTENDED_DESKTOP_SIZE) {
                    int numberOfScreen = this.reader.readByte();
                    this.reader.readBytes(3);
                    LinkedList<FramebufferUpdateRectangle> screens = new LinkedList<FramebufferUpdateRectangle>();
                    for (int i = 0; i < numberOfScreen; ++i) {
                        long id = this.reader.readUInt32();
                        int x = this.reader.readUInt16();
                        int y = this.reader.readUInt16();
                        int width = this.reader.readUInt16();
                        int height = this.reader.readUInt16();
                        long flag = this.reader.readUInt32();
                        FramebufferUpdateRectangle screen = new FramebufferUpdateRectangle(x, y, width, height);
                        screen.port = (int)id;
                        screen.time = flag;
                        screens.add(screen);
                        System.out.println("screen " + id + ":x=" + x + " y=" + y + "width=" + width + "height=" + height);
                    }
                    return;
                }
                if (rect.getEncodingType() == EncodingType.DESKTOP_SIZE) {
                    System.out.println("DESKTOP_SIZE");
                    this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(rect.x, rect.y, rect.width, rect.height, false);
                    this.renderer = this.repaintController.createRenderer(this.reader, rect.width, rect.height, this.context.getPixelFormat());
                    if (!this.rfb.hasViewer()) continue;
                    this.setScreenParameter(rect, rect.width, rect.height);
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.INIT_DATA) {
                    int length = this.reader.readInt32() - 6;
                    short id = this.reader.readInt16();
                    int singleWidth = this.reader.readUInt16();
                    int singleHeight = this.reader.readUInt16();
                    byte[] initData = new byte[length];
                    this.reader.read(initData);
                    String name = new String(initData, 24, length - 24, "UTF-8");
                    this.context.setRemoteDesktopName(name);
                    this.context.setInitData(initData);
                    this.context.setFbWidth(rect.width);
                    this.context.setFbHeight(rect.height);
                    this.repaintController.updateRemoteDesktopName(this.context);
                    this.reader.reset();
                    this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(rect.x, rect.y, singleWidth, singleHeight, false);
                    this.rfb.readSendData(length + 16 + 10, this.reader, null, rect);
                    if (!this.rfb.getCuiVersion()) {
                        this.renderer = this.repaintController.createRenderer(this.reader, rect.width, rect.height, this.context.getPixelFormat());
                    }
                    this.rfb.setSharingId(id);
                    if (!this.rfb.hasViewer()) continue;
                    this.setScreenParameter(rect, singleWidth, singleHeight);
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.CHECK_DELAY) {
                    int checkDelaySize = 24;
                    int port = this.rfb.acceptPort;
                    String address = this.rfb.getMyAddress();
                    int dataLen = this.reader.readInt32();
                    this.sendCheckDelayReply(rect.time, port, address, dataLen);
                    this.reader.reset();
                    this.reader.readBytes(24);
                    decoder = this.decoders.getDecoderByType(EncodingType.ZRLEE);
                    decoder.decode(this.reader, this.renderer, rect);
                    this.repaintController.repaintBitmap(rect);
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.SOUND) continue;
                if (rect.getEncodingType() == EncodingType.ERROR_ANNOUNCE) {
                    short id = (short)rect.x;
                    int length = this.reader.readInt32();
                    byte[] errorMessage = new byte[length];
                    this.reader.read(errorMessage);
                    String errorMessageStr = new String(errorMessage, "UTF-8");
                    if (id == this.rfb.getId()) {
                        this.rfb.getViewer().getConnectionPresenter().showPortErrorDialog(errorMessageStr);
                        this.rfb.getViewer().getConnectionPresenter().clearMessage();
                        continue;
                    }
                    this.reader.reset();
                    this.rfb.readSendData(length + 20, this.reader, null, rect);
                    continue;
                }
                throw new CommonException("Unprocessed encoding: " + rect.toString());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.getMessage();
            e.printStackTrace();
            this.reader.close();
        }
        if (this.rfb.isTreeManager()) {
            this.sendFrameBufferUpdateRequest();
        }
    }

    private void setScreenParameter(FramebufferUpdateRectangle rect, int singleWidth, int singleHeight) {
        ViewerInterface v = this.rfb.getViewer();
        ConnectionPresenter cp = v.getConnectionPresenter();
        cp.setX(rect.x);
        cp.setY(rect.y);
        cp.setFrameSizeWidth(rect.width);
        cp.setFrameSizeHeight(rect.height);
        cp.setSingleWidth(singleWidth);
        cp.setSingleHeight(singleHeight);
        this.rfb.setConnectionPresenter(cp);
        v.setFitScreen();
        System.out.println("got INIT_DATA: myID = " + this.rfb.getId() + " sharingID = " + this.rfb.getSharingId());
        if (this.rfb.isTreeManager()) {
            this.repaintController.setVisible(-1 != this.rfb.getSharingId() && this.rfb.getId() != this.rfb.getSharingId());
        } else {
            this.repaintController.setVisible(this.rfb.getId() != this.rfb.getSharingId());
        }
    }

    private void sendFrameBufferUpdateRequest() {
        if (this.needSendPixelFormat) {
            this.needSendPixelFormat = false;
            this.context.setPixelFormat(this.pixelFormat);
            this.context.sendMessage(new SetPixelFormatMessage(this.pixelFormat));
            logger.fine("sent: " + this.pixelFormat);
            this.context.sendMessage(this.fullscreenFbUpdateIncrementalRequest);
            logger.fine("sent: nonincremental fb update");
        } else {
            this.context.sendMessage(this.fullscreenFbUpdateIncrementalRequest);
        }
    }

    private void sendCheckDelayReply(long time, int port, String address, int dataLen) throws UnsupportedEncodingException {
        this.context.sendMessage(new CheckDelayReply(time, port, address, dataLen));
    }

    public synchronized void queueUpdatePixelFormat(PixelFormat pf) {
        this.pixelFormat = pf;
        this.needSendPixelFormat = true;
    }

    public void stopTask() {
        this.isRunning = false;
    }

    private void connectionFinished() {
        this.rfb.vncConnected(true);
    }

    private void getLost(Reader reader) throws Exception {
        int addSerialNumFlag = reader.readInt32();
        long num = reader.readInt64();
        if (addSerialNumFlag == 1 && num != ++this.checkCounter) {
            System.out.println("LostData" + (num - this.checkCounter));
            this.checkCounter = num;
        }
    }
}

