/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.auth;

import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.protocol.auth.AuthHandler;
import com.glavsoft.rfb.protocol.auth.NoneAuthentication;
import com.glavsoft.rfb.protocol.auth.RequireAuthentication;
import com.glavsoft.rfb.protocol.auth.TightAuthentication;
import com.glavsoft.rfb.protocol.auth.VncAuthentication;
import java.util.LinkedHashMap;
import java.util.Map;

public enum SecurityType {
    NONE_AUTHENTICATION(1),
    VNC_AUTHENTICATION(2),
    TIGHT_AUTHENTICATION(16),
    REQUIRE_AUTHENTICATION(32);

    private int id;
    public static Map<Integer, AuthHandler> implementedSecurityTypes;

    private SecurityType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static AuthHandler getAuthHandlerById(int id) throws UnsupportedSecurityTypeException {
        AuthHandler typeSelected = null;
        typeSelected = implementedSecurityTypes.get(id);
        if (null == typeSelected) {
            throw new UnsupportedSecurityTypeException("Not supported: " + id);
        }
        return typeSelected;
    }

    static {
        implementedSecurityTypes = new LinkedHashMap<Integer, AuthHandler>(){
            {
                this.put(TIGHT_AUTHENTICATION.getId(), new TightAuthentication());
                this.put(VNC_AUTHENTICATION.getId(), new VncAuthentication());
                this.put(NONE_AUTHENTICATION.getId(), new NoneAuthentication());
                this.put(REQUIRE_AUTHENTICATION.getId(), new RequireAuthentication());
            }
        };
    }
}

