/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.AbstractConnectionWorkerFactory;
import com.glavsoft.viewer.NetworkConnectionWorker;
import com.glavsoft.viewer.RfbConnectionWorker;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.Viewer;
import com.glavsoft.viewer.ViewerInterface;
import com.glavsoft.viewer.mvp.Presenter;
import com.glavsoft.viewer.mvp.View;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.SwingConnectionWorkerFactory;
import com.glavsoft.viewer.swing.SwingNetworkConnectionWorker;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import com.glavsoft.viewer.swing.WrongParameterException;
import com.glavsoft.viewer.swing.gui.ConnectionView;
import com.glavsoft.viewer.swing.gui.ConnectionsHistory;
import java.net.Socket;
import java.util.logging.Logger;

public class ConnectionPresenter
extends Presenter {
    public static final String PROPERTY_HOST_NAME = "HostName";
    public static final String PROPERTY_RFB_PORT_NUMBER = "PortNumber";
    public static final String PROPERTY_USE_SSH = "UseSsh";
    private static final String PROPERTY_SSH_USER_NAME = "SshUserName";
    private static final String PROPERTY_SSH_HOST_NAME = "SshHostName";
    private static final String PROPERTY_SSH_PORT_NUMBER = "SshPortNumber";
    private static final String PROPERTY_STATUS_BAR_MESSAGE = "Message";
    private static final String PROPERTY_CONNECTION_IN_PROGRESS = "ConnectionInProgress";
    public static final String CONNECTION_PARAMS_MODEL = "ConnectionParamsModel";
    public static final String CONNECTIONS_HISTORY_MODEL = "ConnectionsHistoryModel";
    public static final String CONNECTION_VIEW = "ConnectionView";
    private final boolean hasSshSupport;
    private final boolean allowInteractive;
    private ConnectionsHistory connectionsHistory;
    private ProtocolSettings rfbSettings;
    private UiSettings uiSettings;
    private final Logger logger;
    private RfbConnectionWorker rfbConnectionWorker;
    private AbstractConnectionWorkerFactory connectionWorkerFactory;
    private NetworkConnectionWorker networkConnectionWorker;
    private boolean needReconnection = true;
    private boolean isTreeVNC = false;
    private boolean cuiVersion;
    private boolean noConnection = false;
    public ViewerInterface viewer;
    private ConnectionParams connectionParams;
    private short reconnectingId = (short)-1;
    private int frameSizeWidth;
    private int frameSizeHeight;
    private int singleWidth = 0;
    private int singleHeight = 0;
    private int retinaScale = 1;
    private int x;
    private int y;

    public short getReconnectingId() {
        return this.reconnectingId;
    }

    public void setReconnectingId(short reconnectingId) {
        this.reconnectingId = reconnectingId;
    }

    public ConnectionParams getConnectionParams() {
        return this.connectionParams;
    }

    public void setConnectionParams(ConnectionParams connectionParams) {
        this.connectionParams = connectionParams;
    }

    public ConnectionPresenter(boolean hasSshSupport, boolean allowInteractive) {
        this.hasSshSupport = hasSshSupport;
        this.allowInteractive = allowInteractive;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public void startConnection(ProtocolSettings rfbSettings, UiSettings uiSettings, int paramSettingsMask, boolean exchangeSocket, Reader is, Writer os) throws IllegalStateException {
        this.rfbSettings = rfbSettings;
        this.uiSettings = uiSettings;
        if (!this.isModelRegisteredByName(CONNECTION_PARAMS_MODEL)) {
            throw new IllegalStateException("No Connection Params model added.");
        }
        if (!this.isTreeVNC) {
            this.connectionsHistory = new ConnectionsHistory();
            this.addModel(CONNECTIONS_HISTORY_MODEL, this.connectionsHistory);
            this.syncModels(paramSettingsMask);
        }
        if (exchangeSocket) {
            this.rfbConnectionWorker.startVNCConnectionWithSocket(is, os);
            return;
        }
        if (this.allowInteractive) {
            this.show();
            this.populate();
        } else if (!this.noConnection) {
            this.connect();
        }
    }

    public void setNoConnection(boolean c) {
        this.noConnection = c;
        this.needReconnection = false;
    }

    public void setUseSsh(boolean useSsh) {
        this.setModelProperty(PROPERTY_USE_SSH, useSsh, Boolean.TYPE);
    }

    public void submitConnection(String hostName) throws WrongParameterException {
        if (Strings.isTrimmedEmpty(hostName)) {
            throw new WrongParameterException("Host name is empty", PROPERTY_HOST_NAME);
        }
        this.setModelProperty(PROPERTY_HOST_NAME, hostName);
        String rfbPort = (String)this.getViewPropertyOrNull(PROPERTY_RFB_PORT_NUMBER);
        this.setModelProperty(PROPERTY_RFB_PORT_NUMBER, rfbPort);
        try {
            this.throwPossiblyHappenedException();
        }
        catch (Throwable e) {
            throw new WrongParameterException("Wrong Port", PROPERTY_HOST_NAME);
        }
        this.setSshOptions();
        this.saveHistory();
        this.populateFrom(CONNECTIONS_HISTORY_MODEL);
        this.connect();
    }

    public void saveHistory() {
        ConnectionParams cp = (ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL);
        if (cp == null) {
            return;
        }
        this.connectionsHistory.reorder(cp, this.rfbSettings, this.uiSettings);
        this.connectionsHistory.save();
    }

    private void connect() {
        ConnectionParams connectionParams = (ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL);
        this.networkConnectionWorker = !this.cuiVersion ? this.connectionWorkerFactory.createNetworkConnectionWorker() : new SwingNetworkConnectionWorker(null);
        this.networkConnectionWorker.setConnectionParams(connectionParams);
        this.networkConnectionWorker.setPresenter(this);
        this.networkConnectionWorker.setHasSshSupport(this.hasSshSupport);
        this.networkConnectionWorker.execute();
    }

    public void connectionFailed() {
        this.cancelConnection();
        if (this.isTreeVNC) {
            return;
        }
        if (this.allowInteractive) {
            this.enableConnectionDialog();
        } else {
            this.connect();
        }
    }

    public void connectionCancelled() {
        this.cancelConnection();
        if (this.isTreeVNC) {
            return;
        }
        if (this.allowInteractive) {
            this.enableConnectionDialog();
        } else {
            ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
            if (connectionView != null) {
                connectionView.closeApp();
            }
        }
    }

    private void enableConnectionDialog() {
        this.setViewProperty(PROPERTY_CONNECTION_IN_PROGRESS, false, Boolean.TYPE);
    }

    public void successfulNetworkConnection(Socket workingSocket) {
        this.logger.info("Connected");
        this.showMessage("Connected");
        this.rfbConnectionWorker = this.connectionWorkerFactory.createRfbConnectionWorker();
        this.rfbConnectionWorker.setWorkingSocket(workingSocket);
        this.rfbConnectionWorker.setRfbSettings(this.rfbSettings);
        this.rfbConnectionWorker.setUiSettings(this.uiSettings);
        this.rfbConnectionWorker.setConnectionString(this.getModelProperty(PROPERTY_HOST_NAME) + ":" + this.getModelProperty(PROPERTY_RFB_PORT_NUMBER));
        this.rfbConnectionWorker.execute();
    }

    public void successfulRfbConnection() {
        this.enableConnectionDialog();
        this.getView(CONNECTION_VIEW).closeView();
    }

    public void cancelConnection() {
        if (this.networkConnectionWorker != null) {
            this.networkConnectionWorker.cancel();
        }
        if (this.rfbConnectionWorker != null) {
            this.rfbConnectionWorker.cancel();
        }
    }

    public void showConnectionErrorDialog(String message) {
        if (this.isTreeVNC) {
            return;
        }
        ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
        if (connectionView != null) {
            connectionView.showConnectionErrorDialog(message);
        }
    }

    public void showPortErrorDialog(String message) {
        if (this.isTreeVNC) {
            return;
        }
        ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
        if (connectionView != null) {
            connectionView.showErrorDialog(message);
        }
    }

    public void showReconnectDialog(String errorTitle, String errorMessage) {
        if (this.isTreeVNC) {
            return;
        }
        ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
        if (connectionView != null && this.needReconnection) {
            connectionView.showReconnectDialog(errorTitle, errorMessage);
        }
    }

    public boolean showShareSoundDialog() {
        if (this.isTreeVNC) {
            return false;
        }
        ConnectionView connectionView = (ConnectionView)this.getView(CONNECTION_VIEW);
        boolean shareSound = false;
        if (connectionView != null) {
            shareSound = connectionView.showShareSoundDialog();
        }
        return shareSound;
    }

    private void setSshOptions() {
        if (this.hasSshSupport) {
            try {
                boolean useSsh = (Boolean)this.getViewProperty(PROPERTY_USE_SSH);
                this.setModelProperty(PROPERTY_USE_SSH, useSsh, Boolean.TYPE);
            }
            catch (Presenter.PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            this.setModelProperty(PROPERTY_SSH_USER_NAME, this.getViewPropertyOrNull(PROPERTY_SSH_USER_NAME));
            this.setModelProperty(PROPERTY_SSH_HOST_NAME, this.getViewPropertyOrNull(PROPERTY_SSH_HOST_NAME));
            this.setModelProperty(PROPERTY_SSH_PORT_NUMBER, this.getViewPropertyOrNull(PROPERTY_SSH_PORT_NUMBER));
            this.setViewProperty(PROPERTY_SSH_PORT_NUMBER, this.getModelProperty(PROPERTY_SSH_PORT_NUMBER));
        }
    }

    private void syncModels(int paramSettingsMask) {
        ConnectionParams cp = (ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL);
        ConnectionParams mostSuitableConnection = this.connectionsHistory.getMostSuitableConnection(cp);
        cp.completeEmptyFieldsFrom(mostSuitableConnection);
        this.rfbSettings.copyDataFrom(this.connectionsHistory.getProtocolSettings(mostSuitableConnection), paramSettingsMask & 0xFFFF);
        this.uiSettings.copyDataFrom(this.connectionsHistory.getUiSettingsData(mostSuitableConnection), paramSettingsMask >> 16 & 0xFFFF);
        if (!cp.isHostNameEmpty()) {
            this.connectionsHistory.reorder(cp, this.rfbSettings, this.uiSettings);
        }
    }

    public void populateFromHistoryItem(ConnectionParams connectionParams) {
        this.setModelProperty(PROPERTY_HOST_NAME, connectionParams.hostName);
        this.setModelProperty(PROPERTY_RFB_PORT_NUMBER, connectionParams.getPortNumber(), Integer.TYPE);
        this.setModelProperty(PROPERTY_USE_SSH, connectionParams.useSsh(), Boolean.TYPE);
        this.setModelProperty(PROPERTY_SSH_HOST_NAME, connectionParams.sshHostName);
        this.setModelProperty(PROPERTY_SSH_PORT_NUMBER, connectionParams.getSshPortNumber(), Integer.TYPE);
        this.setModelProperty(PROPERTY_SSH_USER_NAME, connectionParams.sshUserName);
        this.populateFrom(CONNECTION_PARAMS_MODEL);
        this.rfbSettings.copyDataFrom(this.connectionsHistory.getProtocolSettings(connectionParams));
        this.uiSettings.copyDataFrom(this.connectionsHistory.getUiSettingsData(connectionParams));
    }

    public void clearHistory() {
        this.connectionsHistory.clear();
        this.connectionsHistory.reorder((ConnectionParams)this.getModel(CONNECTION_PARAMS_MODEL), this.rfbSettings, this.uiSettings);
        this.populateFrom(CONNECTIONS_HISTORY_MODEL);
        this.clearMessage();
    }

    public void showMessage(String message) {
        this.setViewProperty(PROPERTY_STATUS_BAR_MESSAGE, message);
    }

    public void clearMessage() {
        this.showMessage("");
    }

    public void setConnectionWorkerFactory(AbstractConnectionWorkerFactory connectionWorkerFactory) {
        this.connectionWorkerFactory = connectionWorkerFactory;
    }

    public void reconnect(String predefinedPassword) {
        this.connectionWorkerFactory.setPredefinedPassword(predefinedPassword);
        if (this.allowInteractive) {
            this.clearMessage();
            this.enableConnectionDialog();
            this.show();
            this.populate();
        } else if (this.needReconnection) {
            this.connect();
        }
    }

    public void clearPredefinedPassword() {
        this.connectionWorkerFactory.setPredefinedPassword(null);
    }

    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    public ProtocolSettings getRfbSettings() {
        return this.rfbSettings;
    }

    public boolean needReconnection() {
        return this.needReconnection;
    }

    public void setNeedReconnection(boolean need) {
        this.needReconnection = need;
    }

    public boolean allowInteractive() {
        return this.allowInteractive;
    }

    public void setIsTreeVNC(boolean flag) {
        this.isTreeVNC = flag;
    }

    public void setCuiVersion(boolean b) {
        this.cuiVersion = b;
    }

    public void setFrameSizeWidth(int frameSizeWidth) {
        this.frameSizeWidth = frameSizeWidth;
    }

    public void setFrameSizeHeight(int frameSizeHeight) {
        this.frameSizeHeight = frameSizeHeight;
    }

    public void setRetinaScale(int retinaScale) {
        this.retinaScale = retinaScale;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getFrameSizeWidth() {
        return this.frameSizeWidth;
    }

    public int getFrameSizeHeight() {
        return this.frameSizeHeight;
    }

    public int getRetinaScale() {
        return this.retinaScale;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public SwingViewerWindow getViewer() {
        if (this.rfbConnectionWorker != null) {
            return this.rfbConnectionWorker.getViewer();
        }
        return null;
    }

    public Socket getSocket() {
        return this.rfbConnectionWorker.getSocket();
    }

    public void startVNCConnection(Viewer viewer, boolean exchangeSocket, Reader is, Writer os) {
        this.viewer = viewer;
        boolean hasJsch = viewer.checkJsch();
        ConnectionView connectionView = new ConnectionView(viewer, this, hasJsch);
        this.addView(CONNECTION_VIEW, connectionView);
        if (viewer.isApplet) {
            this.addView("AppletStatusStringView", new View(){

                @Override
                public void showView() {
                }

                @Override
                public void closeView() {
                }
            });
        }
        SwingViewerWindowFactory viewerWindowFactory = new SwingViewerWindowFactory(viewer.isSeparateFrame, viewer.isApplet, viewer, viewer.width, viewer.height);
        this.setConnectionWorkerFactory(new SwingConnectionWorkerFactory(connectionView.getFrame(), viewer.passwordFromParams, this, viewerWindowFactory, viewer.myRfb));
        this.setNeedReconnection(!viewer.noConnection);
        this.startConnection(viewer.settings, viewer.uiSettings, viewer.paramsMask, exchangeSocket, is, os);
    }

    public int getSingleWidth() {
        return this.singleWidth;
    }

    public int getSingleHeight() {
        return this.singleHeight;
    }

    public void setSingleWidth(int singleWidth) {
        this.singleWidth = singleWidth;
    }

    public void setSingleHeight(int signleHeight) {
        this.singleHeight = signleHeight;
    }
}

