/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.FbRectangle;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.Viewer;
import com.glavsoft.viewer.ViewerInterface;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.ParametersHandler;
import com.glavsoft.viewer.swing.SwingConnectionWorkerFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jp.ac.u_ryukyu.treevnc.CreateConnectionParam;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class CuiViewer
implements Runnable,
WindowListener,
ViewerInterface {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private int paramsMask;
    private boolean allowAppletInteractiveConnections;
    public final ConnectionParams connectionParams = new ConnectionParams();
    protected String passwordFromParams;
    boolean isSeparateFrame = true;
    protected boolean isApplet = true;
    private final ProtocolSettings settings = ProtocolSettings.getDefaultSettings();
    protected UiSettings uiSettings = new UiSettings();
    private ConnectionPresenter connectionPresenter;
    protected TreeRFBProto myRfb;
    private boolean cuiVersion;
    private boolean showTree = false;
    public int width;
    public int height;

    public static void main(String[] args) {
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions(parser);
        parser.parse(args);
        if (parser.isSet("help")) {
            CuiViewer.printUsage(parser.optionsUsage());
            System.exit(0);
        }
        CuiViewer viewer = new CuiViewer(parser);
        SwingUtilities.invokeLater(viewer);
    }

    public static void printUsage(String additional) {
        System.out.println("Usage: java -jar (progfilename) [hostname [port_number]] [Options]?n    or?n java -jar (progfilename) [Options]?n    or?n java -jar (progfilename) -help?n    to view this help?n?nWhere Options are:?n" + additional + "?nOptions format: -optionName=optionValue. Ex. -host=localhost -port=5900 -viewonly=yes?nBoth option name and option value are case insensitive.");
    }

    public CuiViewer() {
    }

    private CuiViewer(Parser parser) {
        this();
        this.setLoggingLevel(parser.isSet("v") ? Level.FINE : (parser.isSet("vv") ? Level.FINER : Level.INFO));
        this.paramsMask = ParametersHandler.completeSettingsFromCLI(parser, this.connectionParams, this.settings, this.uiSettings);
        this.passwordFromParams = parser.getValueFor("password");
        this.logger.info("TightVNC Viewer version " + CuiViewer.ver());
        this.isApplet = false;
    }

    private void setLoggingLevel(Level levelToSet) {
        Logger appLogger = Logger.getLogger("com.glavsoft");
        appLogger.setLevel(levelToSet);
        Handler ch = null;
        for (Handler h : appLogger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ch = (ConsoleHandler)h;
            break;
        }
        if (null == ch) {
            ch = new ConsoleHandler();
            appLogger.addHandler(ch);
        }
        ch.setLevel(levelToSet);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Window w;
        if (e != null && e.getComponent() != null && (w = e.getWindow()) != null) {
            w.setVisible(false);
            w.dispose();
        }
        this.closeApp();
    }

    @Override
    public void closeApp() {
    }

    private boolean checkJsch() {
        try {
            Class.forName("com.jcraft.jsch.JSch");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void run() {
        boolean hasJsch = this.checkJsch();
        boolean allowInteractive = this.allowAppletInteractiveConnections || !this.isApplet;
        ConnectionPresenter connectionPresenter = new ConnectionPresenter(hasJsch, allowInteractive);
        connectionPresenter.addModel("ConnectionParamsModel", this.connectionParams);
        connectionPresenter.setConnectionWorkerFactory(new SwingConnectionWorkerFactory(null, this.passwordFromParams, connectionPresenter, null, this.myRfb));
        connectionPresenter.setCuiVersion(true);
        connectionPresenter.startConnection(this.settings, this.uiSettings, this.paramsMask, false, null, null);
    }

    @Override
    public ConnectionPresenter getConnectionPresenter() {
        return this.connectionPresenter;
    }

    @Override
    public void setConnectionPresenter(ConnectionPresenter connectionPresenter) {
        this.connectionPresenter = connectionPresenter;
    }

    @Override
    public void changeToDirectConnectedServer(String hostName, Reader is, Writer os, int x, int y, int width, int height, int scale) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static String ver() {
        InputStream mfStream = Viewer.class.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        if (null == mfStream) {
            System.out.println("No Manifest file found.");
            return "-1";
        }
        try {
            Manifest mf = new Manifest();
            mf.read(mfStream);
            Attributes atts = mf.getMainAttributes();
            return atts.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (IOException e) {
            return "-2";
        }
    }

    @Override
    public void setSocket(Socket soc) {
        this.connectionParams.setConnectionParam(soc.getInetAddress().getHostAddress(), soc.getPort());
    }

    public void setOpenPort(int parseInt) {
    }

    @Override
    public void setTerminationType(boolean b) {
        this.myRfb.setTerminationType(b);
    }

    @Override
    public void startTreeViewer(String hostName, boolean cui, boolean addSerialNum) {
        CuiViewer viewer = new CuiViewer();
        viewer.cuiVersion = cui;
        TreeRFBProto rfb = new TreeRFBProto(false, this);
        CreateConnectionParam cp = new CreateConnectionParam(rfb);
        if (hostName == null) {
            cp.findTreeVncRoot();
        } else {
            cp.setHostName(hostName);
        }
        rfb.createConnectionAndStart(this);
        cp.sendWhereToConnect(viewer);
        rfb.setCuiVersion(cui);
        viewer.myRfb = rfb;
        SwingUtilities.invokeLater(viewer);
    }

    public void setIsTreeVNC(boolean flag) {
    }

    @Override
    public TreeRFBProto getRfb() {
        return this.myRfb;
    }

    @Override
    public boolean getCuiVersion() {
        return this.cuiVersion;
    }

    @Override
    public void setCuiVersion(boolean flag) {
    }

    @Override
    public void connectToParenet(int port, String hostname) throws IOException {
        this.setTerminationType(false);
        this.closeApp();
        this.connectionParams.setConnectionParam(hostname, port);
        this.run();
    }

    @Override
    public void inhelitClients(String hostName, short newVNCServerId, int x, int y, int width, int height, int scale) {
    }

    @Override
    public void proxyStart(String[] args, String hostName, int width, int height, boolean showTree, boolean checkDelay, boolean addSerialNum, boolean fixingSize, boolean filterSingleDisplay, boolean hasViewer) {
    }

    @Override
    public void setNoConnection(boolean noConnection) {
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public Socket getVNCSocket() {
        return this.connectionPresenter.getSocket();
    }

    @Override
    public boolean getShowTree() {
        return this.showTree;
    }

    @Override
    public void setWidth(int w) {
        this.width = w;
    }

    @Override
    public void setHeight(int h) {
        this.height = h;
    }

    @Override
    public void setFixingSize(int width, int height) {
    }

    @Override
    public ArrayList<FbRectangle> getScreenRectangles() {
        return null;
    }

    @Override
    public Point getScreenOffset(ArrayList<Rectangle> rectangles) {
        return null;
    }

    @Override
    public int retinaScale(int shareScreenNumber) {
        return 1;
    }

    @Override
    public void setFitScreen() {
    }
}

