/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.viewer.CuiViewer;
import com.glavsoft.viewer.Viewer;
import com.glavsoft.viewer.ViewerInterface;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import jp.ac.u_ryukyu.treevnc.VncProxyService;

public class TreeViewer {
    private boolean treeProxy;
    private boolean viewer;
    private boolean cui = false;
    private int width;
    private int height;
    private int fixingSizeWidth;
    private int fixingSizeHeight;
    private String hostName = null;
    private String logFileName = null;
    private boolean noConnection = false;
    private boolean permitChangeScreen = true;
    private boolean showTree = false;
    private boolean checkDelay = false;
    private boolean addSerialNum = false;
    private boolean fixingSizeDisplay = false;
    private boolean logFile = false;
    private boolean filterSingleDisplay = false;
    private boolean direct = false;

    public static void main(String[] args) throws SocketException, UnknownHostException {
        new TreeViewer().vncStart(args);
    }

    private void vncStart(String[] args) throws SocketException, UnknownHostException {
        this.modeSelect(args);
        if (this.logFile) {
            PrintStream out = null;
            try {
                out = new PrintStream(this.logFileName + ".txt");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.setOut(out);
        }
        if (this.treeProxy && !this.viewer) {
            VncProxyService vps = new VncProxyService();
            if (this.fixingSizeDisplay) {
                this.setFixingSizeDisplay(vps);
            }
            this.rootStart(args, vps);
            return;
        }
        if (this.viewer) {
            WindowListener v = this.cui ? new CuiViewer() : new Viewer();
            this.setWidthAndHeight((ViewerInterface)((Object)v));
            if (this.fixingSizeDisplay) {
                this.setFixingSizeDisplay((ViewerInterface)((Object)v));
            }
            if (this.treeProxy) {
                if (this.hostName != null) {
                    if (this.direct) {
                        this.rootStart(args, new VncProxyService());
                        return;
                    }
                    v.startTreeViewer(this.hostName, this.cui, this.addSerialNum);
                }
                this.rootStart(args, (ViewerInterface)((Object)v));
            } else {
                v.startTreeViewer(this.hostName, this.cui, this.addSerialNum);
                if (v.getRfb().getConnectionParam().isDisplayMode()) {
                    this.noConnection = true;
                    this.treeProxy = true;
                    this.viewer = true;
                    this.rootStart(args, (ViewerInterface)((Object)v));
                } else if (v.getRfb().getConnectionParam().isRootMode()) {
                    this.viewer = false;
                    this.treeProxy = true;
                    this.rootStart(args, (ViewerInterface)((Object)v));
                }
            }
        }
    }

    public void rootStart(String[] args, ViewerInterface v) throws SocketException, UnknownHostException {
        v.setNoConnection(this.noConnection);
        v.proxyStart(args, this.hostName, this.width, this.height, this.showTree, this.checkDelay, this.addSerialNum, this.fixingSizeDisplay, this.filterSingleDisplay, this.viewer);
        if (!this.permitChangeScreen) {
            v.getRfb().setPermitChangeScreen(false);
        }
        v.getRfb().getAcceptThread().waitForShutdown();
    }

    private void modeSelect(String[] args) {
        this.viewer = true;
        for (int i = 0; i < args.length; ++i) {
            if ("-p".equals(args[i]) || "-r".equals(args[i])) {
                this.treeProxy = true;
                this.viewer = false;
                continue;
            }
            if ("-d".equals(args[i])) {
                this.noConnection = true;
                this.treeProxy = true;
                this.viewer = true;
                continue;
            }
            if ("--cui".equals(args[i])) {
                this.cui = true;
                continue;
            }
            if ("-v".equals(args[i]) || "-c".equals(args[i])) {
                this.viewer = true;
                continue;
            }
            if ("--version".equals(args[i])) {
                System.out.println("version :" + Viewer.ver());
                System.exit(0);
                continue;
            }
            if ("-ns".equals(args[i])) {
                this.permitChangeScreen = false;
                continue;
            }
            if ("--noScreenChange".equals(args[i])) {
                this.permitChangeScreen = false;
                continue;
            }
            if ("--fixSize".equals(args[i])) {
                this.fixingSizeWidth = Integer.parseInt(args[++i]);
                this.fixingSizeHeight = Integer.parseInt(args[++i]);
                this.fixingSizeDisplay = true;
                continue;
            }
            if ("--width".equals(args[i])) {
                this.width = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if ("--height".equals(args[i])) {
                this.height = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if ("--host".equals(args[i])) {
                this.hostName = args[++i];
                this.treeProxy = true;
                continue;
            }
            if ("--direct".equals(args[i])) {
                this.direct = true;
                continue;
            }
            if ("--showTree".equals(args[i])) {
                this.showTree = true;
                continue;
            }
            if ("--checkDelay".equals(args[i])) {
                this.checkDelay = true;
                continue;
            }
            if ("--addSerialNum".equals(args[i])) {
                this.addSerialNum = true;
                continue;
            }
            if ("--logFile".equals(args[i])) {
                this.logFile = true;
                try {
                    this.logFileName = args[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Please put the log file name. If you do not put file name, set file name logFile.txt");
                }
                if (this.logFileName == null) {
                    this.logFileName = "logFile";
                    continue;
                }
                if ("-".equals(this.logFileName.substring(0, 1))) {
                    System.out.println("Please put the log file name. If you do not put file name, set file name logFile.txt");
                    this.logFileName = "logFile";
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            System.out.println("(default) TreeVNCClient\n-v or -c:                View shared screen.\n-p:                      (proxy) Share my screen and behave as tree root.\n-ns --noScreenChange:    Viewers cannot change screen to thiers (default permite screen change)\n-d:                      Show shared screen and behave as tree root.\n-r:                      Connect to fix to specified host and port.\n--host hostname:         Set host name.\n--retina:                Limit screen size for very large display.\n--width w:               Set display width.\n--height h:              Set display height.\n--showTree:              Show connected tree node.\n--checkDelay:            Check speed flow of data each node.\n--logFile logFileName:   Set log file name.\n--fixingSize w h:        Fix share screen size.\n--addSerialNum:          Check lost data.\n");
            System.exit(0);
        }
    }

    public void setWidthAndHeight(ViewerInterface v) {
        if (this.width != 0 || this.height != 0) {
            v.setWidth(this.width);
            v.setHeight(this.height);
        }
    }

    public void setFixingSizeDisplay(ViewerInterface v) {
        v.setFixingSize(this.fixingSizeWidth, this.fixingSizeHeight);
    }

    private boolean isInteger(String num) {
        try {
            Integer.parseInt(num);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

