/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.FbRectangle;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.ViewerInterface;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.ParametersHandler;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import jp.ac.u_ryukyu.treevnc.CreateConnectionParam;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class Viewer
extends JApplet
implements Runnable,
WindowListener,
ViewerInterface {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public int paramsMask;
    public boolean allowAppletInteractiveConnections;
    public final ConnectionParams connectionParams = new ConnectionParams();
    public String passwordFromParams;
    public boolean isSeparateFrame = true;
    public boolean isApplet = true;
    public final ProtocolSettings settings = ProtocolSettings.getDefaultSettings();
    public UiSettings uiSettings = new UiSettings();
    private volatile boolean isAppletStopped = false;
    private ConnectionPresenter connectionPresenter;
    boolean isTreeVNC = false;
    public TreeRFBProto myRfb;
    public boolean noConnection;
    public int vncport = 5900;
    private int fbWidth;
    private boolean showTree = false;
    public int width;
    public int height;
    public int fixingSizeWidth;
    public int fixingSizeHeight;

    public static void main(String[] args) {
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions(parser);
        parser.parse(args);
        if (parser.isSet("help")) {
            Viewer.printUsage(parser.optionsUsage());
            System.exit(0);
        }
        Viewer viewer = new Viewer(parser);
        SwingUtilities.invokeLater(viewer);
    }

    public static void printUsage(String additional) {
        System.out.println("Usage: java -jar (progfilename) [hostname [port_number]] [Options]\u00a5n    or\u00a5n java -jar (progfilename) [Options]\u00a5n    or\u00a5n java -jar (progfilename) -help\u00a5n    to view this help\u00a5n\u00a5nWhere Options are:\u00a5n" + additional + "\u00a5nOptions format: -optionName=optionValue. Ex. -host=localhost -port=5900 -viewonly=yes\u00a5nBoth option name and option value are case insensitive.");
    }

    public Viewer() {
    }

    private Viewer(Parser parser) {
        this();
        this.setLoggingLevel(parser.isSet("v") ? Level.FINE : (parser.isSet("vv") ? Level.FINER : Level.INFO));
        this.paramsMask = ParametersHandler.completeSettingsFromCLI(parser, this.connectionParams, this.settings, this.uiSettings);
        this.passwordFromParams = parser.getValueFor("password");
        this.logger.info("TightVNC Viewer version " + Viewer.ver());
        this.isApplet = false;
    }

    private void setLoggingLevel(Level levelToSet) {
        Logger appLogger = Logger.getLogger("com.glavsoft");
        appLogger.setLevel(levelToSet);
        Handler ch = null;
        for (Handler h : appLogger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ch = (ConsoleHandler)h;
            break;
        }
        if (null == ch) {
            ch = new ConsoleHandler();
            appLogger.addHandler(ch);
        }
        ch.setLevel(levelToSet);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Window w;
        if (e != null && e.getComponent() != null && (w = e.getWindow()) != null) {
            w.setVisible(false);
            w.dispose();
        }
        this.closeApp();
    }

    @Override
    public void closeApp() {
        if (this.connectionPresenter != null) {
            this.connectionPresenter.cancelConnection();
            this.logger.info("Connections cancelled.");
        }
        if (this.isApplet) {
            if (!this.isAppletStopped) {
                this.logger.severe("Applet is stopped.");
                this.isAppletStopped = true;
                this.repaint();
                this.stop();
            }
        } else {
            System.exit(0);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isAppletStopped) {
            super.paint(g);
        } else {
            this.getContentPane().removeAll();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawString("Disconnected", 10, 20);
        }
    }

    @Override
    public void destroy() {
        this.closeApp();
        super.destroy();
    }

    @Override
    public void init() {
        this.paramsMask = ParametersHandler.completeSettingsFromApplet(this, this.connectionParams, this.settings, this.uiSettings);
        this.isSeparateFrame = ParametersHandler.isSeparateFrame;
        this.passwordFromParams = this.getParameter("password");
        this.isApplet = true;
        this.allowAppletInteractiveConnections = ParametersHandler.allowAppletInteractiveConnections;
        this.repaint();
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
        }
    }

    @Override
    public void start() {
        super.start();
    }

    public boolean checkJsch() {
        try {
            Class.forName("com.jcraft.jsch.JSch");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void setNoConnection(boolean c) {
        this.noConnection = c;
    }

    @Override
    public void run() {
        boolean hasJsch = this.checkJsch();
        boolean allowInteractive = this.allowAppletInteractiveConnections || !this.isApplet;
        this.connectionPresenter = new ConnectionPresenter(hasJsch, allowInteractive);
        this.connectionPresenter.setNoConnection(this.noConnection);
        this.connectionPresenter.addModel("ConnectionParamsModel", this.connectionParams);
        this.connectionPresenter.startVNCConnection(this, false, null, null);
    }

    @Override
    public ConnectionPresenter getConnectionPresenter() {
        return this.connectionPresenter;
    }

    @Override
    public void setConnectionPresenter(ConnectionPresenter connectionPresenter) {
        this.connectionPresenter = connectionPresenter;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static String ver() {
        InputStream mfStream = Viewer.class.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        if (null == mfStream) {
            System.out.println("No Manifest file found.");
            return "-1";
        }
        try {
            Manifest mf = new Manifest();
            mf.read(mfStream);
            Attributes atts = mf.getMainAttributes();
            return atts.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (IOException e) {
            return "-2";
        }
    }

    @Override
    public void setSocket(Socket soc) {
        this.connectionParams.setConnectionParam(soc.getInetAddress().getHostAddress(), soc.getPort());
    }

    public void setOpenPort(int parseInt) {
    }

    @Override
    public void setTerminationType(boolean b) {
        this.myRfb.setTerminationType(b);
    }

    @Override
    public void connectToParenet(int port, String hostname) throws IOException {
        this.setTerminationType(false);
        this.closeApp();
        this.connectionParams.setConnectionParam(hostname, port);
        this.run();
    }

    public void setIsTreeVNC(boolean flag) {
        this.isTreeVNC = flag;
    }

    @Override
    public TreeRFBProto getRfb() {
        return this.myRfb;
    }

    @Override
    public boolean getCuiVersion() {
        return this.myRfb.getCuiVersion();
    }

    @Override
    public void setCuiVersion(boolean flag) {
        this.myRfb.setCuiVersion(flag);
    }

    public void setVncport(int vncport) {
        this.vncport = vncport;
    }

    @Override
    public void inhelitClients(String hostName, short newVNCServerId, int x, int y, int width, int height, int scale) {
        final ConnectionPresenter connectionPresenter = this.createNewConnectionPresenter(hostName, newVNCServerId, x, y, width, height, scale);
        this.isApplet = true;
        this.setNoConnection(false);
        final Viewer v = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                connectionPresenter.startVNCConnection(v, false, null, null);
            }
        }, "ServerChangeThread").start();
    }

    @Override
    public void changeToDirectConnectedServer(String hostName, Reader is, Writer os, int x, int y, int width, int height, int scale) {
        ConnectionPresenter connectionPresenter = this.createNewConnectionPresenter(hostName, (short)-1, x, y, width, height, scale);
        connectionPresenter.startVNCConnection(this, true, is, os);
    }

    private ConnectionPresenter createNewConnectionPresenter(String hostName, short newVNCServerId, int x, int y, int width, int height, int scale) {
        boolean hasJsch = this.checkJsch();
        boolean allowInteractive = this.allowAppletInteractiveConnections || !this.isApplet;
        ConnectionPresenter connectionPresenter = new ConnectionPresenter(hasJsch, allowInteractive);
        ConnectionParams connectionParams = new ConnectionParams();
        connectionParams.setConnectionParam(hostName, this.vncport);
        connectionPresenter.addModel("ConnectionParamsModel", connectionParams);
        connectionPresenter.setConnectionParams(connectionParams);
        connectionPresenter.setReconnectingId(newVNCServerId);
        connectionPresenter.setIsTreeVNC(true);
        connectionPresenter.setNoConnection(false);
        connectionPresenter.setX(x);
        connectionPresenter.setY(y);
        connectionPresenter.setSingleWidth(width);
        connectionPresenter.setSingleHeight(height);
        connectionPresenter.setRetinaScale(scale);
        return connectionPresenter;
    }

    @Override
    public void startTreeViewer(String hostName, boolean cui, boolean addSerialNum) {
        TreeRFBProto rfb = new TreeRFBProto(false, this);
        rfb.setCuiVersion(cui);
        rfb.setAddSerialNum(addSerialNum);
        rfb.setHasViewer(true);
        rfb.createConnectionAndStart(this);
        CreateConnectionParam cp = new CreateConnectionParam(rfb);
        if (hostName != null) {
            cp.setHostName(hostName);
        } else {
            cp.findTreeVncRoot();
            if (cp.isDisplayMode() || cp.isRootMode()) {
                this.myRfb = rfb;
                this.myRfb.setIsTreeManager(true);
                return;
            }
        }
        cp.sendWhereToConnect(this);
        this.isTreeVNC = true;
        this.myRfb = rfb;
        this.settings.setViewOnly(true);
        rfb.getAcceptThread().waitForShutdown();
    }

    @Override
    public void proxyStart(String[] argv, String hostName, int width, int height, boolean showTree, boolean checkDelay, boolean addSerialNum, boolean fixingSize, boolean filterSingleDisplay, boolean hasViewer) {
        this.fbWidth = width;
        this.showTree = showTree;
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions(parser);
        if (this.fbWidth == 0) {
            parser.parse(argv);
        }
        if (parser.isSet("help")) {
            Viewer.printUsage(parser.optionsUsage());
            System.exit(0);
        }
        if (this.myRfb == null) {
            this.myRfb = new TreeRFBProto(true, this);
        }
        this.myRfb.setCuiVersion(!hasViewer);
        this.myRfb.setHasViewer(hasViewer);
        this.myRfb.setShowTree(showTree);
        this.myRfb.setCheckDelay(checkDelay);
        this.myRfb.setAddSerialNum(addSerialNum);
        this.myRfb.setFixingSize(fixingSize);
        if (fixingSize) {
            this.myRfb.fixingSizeWidth = this.fixingSizeWidth;
            this.myRfb.fixingSizeHeight = this.fixingSizeHeight;
        }
        if (this.myRfb.getAcceptThread() == null) {
            this.myRfb.createConnectionAndStart(this);
        } else {
            this.myRfb.startTreeRootFindThread();
        }
        this.setIsTreeVNC(true);
        if (hostName == null) {
            hostName = "localhost";
        }
        this.connectionParams.setConnectionParam(hostName, this.vncport);
        this.isApplet = true;
        this.settings.setViewOnly(true);
        this.run();
    }

    public void initRoot(TreeRFBProto myRfbProto, String hostName) {
        this.setIsTreeVNC(true);
        this.connectionParams.setConnectionParam(hostName, this.vncport);
        this.isApplet = true;
        myRfbProto.createConnectionAndStart(this);
        this.run();
    }

    @Override
    public void setVisible(boolean b) {
        if (this.connectionPresenter == null) {
            return;
        }
        SwingViewerWindow v = this.connectionPresenter.getViewer();
        if (v != null) {
            v.setVisible(b);
        }
    }

    @Override
    public Socket getVNCSocket() {
        return this.connectionPresenter.getSocket();
    }

    @Override
    public boolean getShowTree() {
        return this.showTree;
    }

    @Override
    public void setWidth(int w) {
        this.width = w;
    }

    @Override
    public void setHeight(int h) {
        this.height = h;
    }

    @Override
    public void setFixingSize(int width, int height) {
        this.fixingSizeWidth = width;
        this.fixingSizeHeight = height;
    }

    @Override
    public ArrayList<FbRectangle> getScreenRectangles() {
        GraphicsDevice[] gs;
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            int screenNumber = 0;
            for (GraphicsConfiguration r : gd.getConfigurations()) {
                Rectangle rect = r.getBounds();
                rectangles.add(rect);
                ++screenNumber;
            }
        }
        Point offset = this.getScreenOffset(rectangles);
        ArrayList<FbRectangle> fbRectangles = new ArrayList<FbRectangle>();
        int screenNumber = 0;
        for (Rectangle rect : rectangles) {
            FbRectangle fbrect = new FbRectangle(rect.x, rect.y, rect.width, rect.height, screenNumber, this.retinaScale(screenNumber));
            fbrect.setXfb(rect.x + offset.x);
            fbrect.setYfb(rect.y + offset.y);
            fbRectangles.add(fbrect);
            ++screenNumber;
        }
        fbRectangles.sort(new Comparator<FbRectangle>(){

            @Override
            public int compare(FbRectangle t0, FbRectangle t1) {
                return t0.getX() < t1.getX() ? -1 : (t0.getX() == t1.getX() ? 0 : 1);
            }
        });
        int retinaOffsetX = 0;
        FbRectangle fbRectanglesPrev = (FbRectangle)fbRectangles.get(0);
        for (int i = 1; i < fbRectangles.size(); ++i) {
            FbRectangle fbRect = (FbRectangle)fbRectangles.get(i);
            if (fbRectanglesPrev.getRetinaScale() != 1 && fbRectanglesPrev.x + fbRectanglesPrev.width <= fbRect.x) {
                retinaOffsetX = (int)((double)retinaOffsetX + fbRectanglesPrev.getWidth() * (double)(fbRectanglesPrev.retinaScale - 1));
            }
            fbRect.setXfb(fbRect.getXfb() + retinaOffsetX);
            fbRectanglesPrev = fbRect;
        }
        fbRectangles.sort(new Comparator<FbRectangle>(){

            @Override
            public int compare(FbRectangle t0, FbRectangle t1) {
                return t0.getY() < t1.getY() ? -1 : (t0.getY() == t1.getY() ? 0 : 1);
            }
        });
        int retinaOffsetY = 0;
        fbRectanglesPrev = (FbRectangle)fbRectangles.get(0);
        for (int i = 1; i < fbRectangles.size(); ++i) {
            FbRectangle fbRect = fbRectangles.get(i);
            if (fbRectanglesPrev.getRetinaScale() != 1 && fbRectanglesPrev.y + fbRectanglesPrev.height <= fbRect.y) {
                retinaOffsetY = (int)((double)retinaOffsetY + fbRectanglesPrev.getHeight() * (double)(fbRectanglesPrev.retinaScale - 1));
            }
            fbRect.setYfb(fbRect.getYfb() + retinaOffsetY);
            fbRectanglesPrev = fbRect;
        }
        return fbRectangles;
    }

    @Override
    public Point getScreenOffset(ArrayList<Rectangle> rectangles) {
        int offsetx = 0;
        int offsety = 0;
        for (Rectangle rect : rectangles) {
            if (rect.x < offsetx) {
                offsetx = rect.x;
            }
            if (rect.y >= offsety) continue;
            offsety = rect.y;
        }
        return new Point(-offsetx, -offsety);
    }

    @Override
    public int retinaScale(int shareScreenNumber) {
        int scale = 1;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        try {
            Field field = devices[shareScreenNumber].getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                Object retinaScale = field.get(devices[shareScreenNumber]);
                if (retinaScale instanceof Integer) {
                    scale = (Integer)retinaScale;
                    return scale;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return scale;
    }

    @Override
    public void setFitScreen() {
        SwingViewerWindow v = this.connectionPresenter.getViewer();
        if (v != null) {
            v.fitScreen();
        }
    }
}

