/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.mvp.Model;
import com.glavsoft.viewer.swing.WrongParameterException;

public class ConnectionParams
implements Model {
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int DEFAULT_RFB_PORT = 5900;
    public static final int DEFAULT_VNC_ROOT = 5950;
    public static final int DEFAULT_RTP_PORT = 60004;
    public static final int DEFAULT_VNC_ROOT_FINDER = 5900;
    public String hostName;
    private int portNumber;
    public String sshUserName;
    public String sshHostName;
    private int sshPortNumber;
    private boolean useSsh;

    public ConnectionParams(String hostName, int portNumber, boolean useSsh, String sshHostName, int sshPortNumber, String sshUserName) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.sshUserName = sshUserName;
        this.sshHostName = sshHostName;
        this.sshPortNumber = sshPortNumber;
        this.useSsh = useSsh;
    }

    public ConnectionParams(ConnectionParams cp) {
        this.hostName = cp.hostName != null ? cp.hostName : "";
        this.portNumber = cp.portNumber;
        this.sshUserName = cp.sshUserName;
        this.sshHostName = cp.sshHostName;
        this.sshPortNumber = cp.sshPortNumber;
        this.useSsh = cp.useSsh;
    }

    public ConnectionParams() {
        this.hostName = "";
        this.sshUserName = "";
        this.sshHostName = "";
    }

    public boolean isHostNameEmpty() {
        return Strings.isTrimmedEmpty(this.hostName);
    }

    public void parseRfbPortNumber(String port) throws WrongParameterException {
        block3: {
            try {
                this.portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                this.portNumber = 0;
                if (Strings.isTrimmedEmpty(port)) break block3;
                throw new WrongParameterException("Wrong port number: " + port + "\nMust be in 0..65535");
            }
        }
        if (this.portNumber > 65535 || this.portNumber < 0) {
            throw new WrongParameterException("Port number is out of range: " + port + "\nMust be in 0..65535");
        }
    }

    public void parseSshPortNumber(String port) {
        try {
            this.sshPortNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPortNumber(String port) throws WrongParameterException {
        this.parseRfbPortNumber(port);
    }

    public int getPortNumber() {
        return 0 == this.portNumber ? 5900 : this.portNumber;
    }

    public void setSshPortNumber(String port) {
        this.parseSshPortNumber(port);
    }

    public void setSshPortNumber(int port) {
        this.sshPortNumber = port;
    }

    public int getSshPortNumber() {
        return 0 == this.sshPortNumber ? 22 : this.sshPortNumber;
    }

    public void setUseSsh(boolean useSsh) {
        this.useSsh = useSsh;
    }

    public boolean useSsh() {
        return this.useSsh && !Strings.isTrimmedEmpty(this.sshHostName);
    }

    public boolean getUseSsh() {
        return this.useSsh();
    }

    public String getSshUserName() {
        return this.sshUserName;
    }

    public void setSshUserName(String sshUserName) {
        this.sshUserName = sshUserName;
    }

    public String getSshHostName() {
        return this.sshHostName;
    }

    public void setSshHostName(String sshHostName) {
        this.sshHostName = sshHostName;
    }

    public void completeEmptyFieldsFrom(ConnectionParams from) {
        if (null == from) {
            return;
        }
        if (Strings.isTrimmedEmpty(this.hostName) && !Strings.isTrimmedEmpty(from.hostName)) {
            this.hostName = from.hostName;
        }
        if (0 == this.portNumber && from.portNumber != 0) {
            this.portNumber = from.portNumber;
        }
        if (Strings.isTrimmedEmpty(this.sshUserName) && !Strings.isTrimmedEmpty(from.sshUserName)) {
            this.sshUserName = from.sshUserName;
        }
        if (Strings.isTrimmedEmpty(this.sshHostName) && !Strings.isTrimmedEmpty(from.sshHostName)) {
            this.sshHostName = from.sshHostName;
        }
        if (0 == this.sshPortNumber && from.sshPortNumber != 0) {
            this.sshPortNumber = from.sshPortNumber;
        }
        this.useSsh |= from.useSsh;
    }

    public String toString() {
        return this.hostName != null ? this.hostName : "";
    }

    public String toPrint() {
        return "ConnectionParams{hostName='" + this.hostName + '\'' + ", portNumber=" + this.portNumber + ", sshUserName='" + this.sshUserName + '\'' + ", sshHostName='" + this.sshHostName + '\'' + ", sshPortNumber=" + this.sshPortNumber + ", useSsh=" + this.useSsh + '}';
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof ConnectionParams)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConnectionParams o = (ConnectionParams)obj;
        return this.isEqualsNullable(this.hostName, o.hostName) && this.getPortNumber() == o.getPortNumber() && this.useSsh == o.useSsh && this.isEqualsNullable(this.sshHostName, o.sshHostName) && this.getSshPortNumber() == o.getSshPortNumber() && this.isEqualsNullable(this.sshUserName, o.sshUserName);
    }

    private boolean isEqualsNullable(String one, String another) {
        return one == another || (null == one ? "" : one).equals(null == another ? "" : another);
    }

    public int hashCode() {
        long hash = (this.hostName != null ? this.hostName.hashCode() : 0) + this.portNumber * 17 + (this.useSsh ? 781 : 693) + (this.sshHostName != null ? this.sshHostName.hashCode() : 0) * 23 + (this.sshUserName != null ? this.sshUserName.hashCode() : 0) * 37 + this.sshPortNumber * 41;
        return (int)hash;
    }

    public void clearFields() {
        this.hostName = "";
        this.portNumber = 0;
        this.useSsh = false;
        this.sshHostName = null;
        this.sshUserName = null;
        this.sshPortNumber = 0;
    }

    public void setConnectionParam(String hostAndPort, int port) {
        this.hostName = hostAndPort;
        this.portNumber = port;
        int i = hostAndPort.indexOf(58);
        if (i > 0) {
            this.portNumber = Integer.parseInt(hostAndPort.substring(i + 1));
            this.hostName = hostAndPort.substring(0, i);
        } else {
            this.hostName = hostAndPort;
        }
    }
}

