/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.transport.Reader;
import com.glavsoft.viewer.swing.SoftCursorImpl;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RendererImpl
extends Renderer
implements ImageObserver {
    CyclicBarrier barrier = new CyclicBarrier(2);
    private final Image offscreanImage;

    public RendererImpl(Reader reader, int width, int height, PixelFormat pixelFormat) {
        if (0 == width) {
            width = 1;
        }
        if (0 == height) {
            height = 1;
        }
        this.init(reader, width, height, pixelFormat);
        DirectColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(width, height);
        DataBufferInt dataBuffer = new DataBufferInt(this.pixels, width * height);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        this.offscreanImage = new BufferedImage(colorModel, raster, false, null);
        this.cursor = new SoftCursorImpl(0, 0, 0, 0);
    }

    @Override
    public void drawJpegImage(byte[] bytes, int offset, int jpegBufferLength, FramebufferUpdateRectangle rect) {
        Image jpegImage = Toolkit.getDefaultToolkit().createImage(bytes, offset, jpegBufferLength);
        Toolkit.getDefaultToolkit().prepareImage(jpegImage, -1, -1, this);
        try {
            this.barrier.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (BrokenBarrierException brokenBarrierException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Graphics graphics = this.offscreanImage.getGraphics();
        graphics.drawImage(jpegImage, rect.x, rect.y, rect.width, rect.height, this);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean isReady;
        boolean bl = isReady = (infoflags & 0xA0) != 0;
        if (isReady) {
            try {
                this.barrier.await();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }
        return !isReady;
    }

    public Image getOffscreenImage() {
        return this.offscreanImage;
    }

    public SoftCursorImpl getCursor() {
        return (SoftCursorImpl)this.cursor;
    }
}

