/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.viewer.CancelConnectionException;
import com.glavsoft.viewer.ConnectionErrorException;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.NetworkConnectionWorker;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.ssh.SshConnectionManager;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class SwingNetworkConnectionWorker
extends SwingWorker<Socket, String>
implements NetworkConnectionWorker {
    public static final int MAX_HOSTNAME_LENGTH_FOR_MESSAGES = 40;
    private final JFrame parentWindow;
    private Logger logger;
    private boolean hasSshSupport;
    private ConnectionParams connectionParams;
    private ConnectionPresenter presenter;
    private TreeRFBProto rfb;

    public SwingNetworkConnectionWorker(JFrame parentWindow, TreeRFBProto myRfb) {
        this.parentWindow = parentWindow;
        this.rfb = myRfb;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public SwingNetworkConnectionWorker(JFrame parentWindow) {
        this.parentWindow = parentWindow;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Socket doInBackground() throws Exception {
        String host;
        int port;
        String s = "<b>" + this.connectionParams.hostName + "</b>:" + this.connectionParams.getPortNumber();
        if (this.connectionParams.useSsh()) {
            s = s + " <i>(via ssh://" + this.connectionParams.sshUserName + "@" + this.connectionParams.sshHostName + ":" + this.connectionParams.getSshPortNumber() + ")</i>";
        }
        String message = "<html>Trying to connect to " + s + "</html>";
        this.logger.info(message.replaceAll("<[^<>]+?>", ""));
        this.publish(message);
        if (this.hasSshSupport && this.connectionParams.useSsh()) {
            SshConnectionManager sshConnectionManager = new SshConnectionManager(this.parentWindow);
            message = "Creating SSH tunnel to " + this.connectionParams.sshHostName + ":" + this.connectionParams.getSshPortNumber();
            this.logger.info(message);
            this.publish(message);
            port = sshConnectionManager.connect(this.connectionParams);
            if (!sshConnectionManager.isConnected()) throw new ConnectionErrorException("Could not create SSH tunnel: " + sshConnectionManager.getErrorMessage());
            host = "127.0.0.1";
            message = "SSH tunnel established: " + host + ":" + port;
            this.logger.info(message);
            this.publish(message);
        } else {
            host = this.connectionParams.hostName;
            port = this.connectionParams.getPortNumber();
        }
        message = "Connecting to host " + host + ":" + port + (this.connectionParams.useSsh() ? " (tunneled)" : "");
        this.logger.info(message);
        this.publish(message);
        return new Socket(host, port);
    }

    private String formatHostString(String hostName) {
        if (hostName.length() <= 40) {
            return hostName;
        }
        return hostName.substring(0, 40) + "...";
    }

    @Override
    protected void process(List<String> strings) {
        String message = strings.get(strings.size() - 1);
        this.presenter.showMessage(message);
    }

    @Override
    protected void done() {
        try {
            Socket socket = (Socket)this.get();
            this.presenter.successfulNetworkConnection(socket);
        }
        catch (CancellationException e) {
            this.logger.info("Cancelled");
            this.presenter.showMessage("Cancelled");
            this.presenter.connectionFailed();
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted");
            this.presenter.showMessage("Interrupted");
            this.presenter.connectionFailed();
        }
        catch (ExecutionException e) {
            System.out.println("lost parent");
            String errorMessage = null;
            try {
                throw e.getCause();
            }
            catch (UnknownHostException uhe) {
                this.logger.severe("Unknown host: " + this.connectionParams.hostName);
                errorMessage = "Unknown host: '" + this.formatHostString(this.connectionParams.hostName) + "'";
            }
            catch (IOException ioe) {
                this.logger.severe("Couldn't connect to '" + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + "':\n" + ioe.getMessage());
                this.logger.log(Level.FINEST, "Couldn't connect to '" + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + "':\n" + ioe.getMessage(), ioe);
                errorMessage = "Couldn't connect to '" + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber() + "':\n" + ioe.getMessage();
            }
            catch (CancelConnectionException cce) {
                this.logger.severe("Cancelled: " + cce.getMessage());
            }
            catch (AccessControlException ace) {
                this.logger.severe("Couldn't connect to: " + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + ": " + ace.getMessage());
                this.logger.log(Level.FINEST, "Couldn't connect to: " + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber() + ": " + ace.getMessage(), ace);
                errorMessage = "Access control error";
            }
            catch (ConnectionErrorException cee) {
                this.logger.severe(cee.getMessage() + " host: " + this.connectionParams.hostName + ":" + this.connectionParams.getPortNumber());
                errorMessage = cee.getMessage() + "\nHost: " + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber();
            }
            catch (Throwable throwable) {
                this.logger.log(Level.FINEST, "Couldn't connect to '" + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber() + "':\n" + throwable.getMessage(), throwable);
                errorMessage = "Couldn't connect to '" + this.formatHostString(this.connectionParams.hostName) + ":" + this.connectionParams.getPortNumber() + "':\n" + throwable.getMessage();
            }
            String message = "please waiting connect to new node \n \n" + errorMessage;
            if (this.rfb.isTreeManager() && this.presenter.getReconnectingId() != this.rfb.getId()) {
                this.rfb.sendErrorAnnounce(this.presenter.getReconnectingId(), message);
                this.presenter.cancelConnection();
            }
            this.presenter.showConnectionErrorDialog(message);
            this.presenter.clearMessage();
            this.presenter.connectionFailed();
        }
    }

    @Override
    public void setConnectionParams(ConnectionParams connectionParams) {
        this.connectionParams = connectionParams;
    }

    @Override
    public void setPresenter(ConnectionPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setHasSshSupport(boolean hasSshSupport) {
        this.hasSshSupport = hasSshSupport;
    }

    @Override
    public boolean cancel() {
        return super.cancel(true);
    }
}

