/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import com.glavsoft.viewer.ViewerInterface;
import jp.ac.u_ryukyu.treevnc.FindRoot;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;
import jp.ac.u_ryukyu.treevnc.TreeVncProtocol;

public class CreateConnectionParam {
    private String hostName;
    private int portNumber = 5950;
    private TreeRFBProto rfb;
    private String myHostName;
    private boolean rootMode = false;
    private boolean displayMode = false;

    public CreateConnectionParam(TreeRFBProto rfb) {
        this.rfb = rfb;
        rfb.setConnectionParam(this);
    }

    public synchronized void findTreeVncRoot() {
        FindRoot getBcast = new FindRoot(this.rfb.acceptPort, this);
        this.rfb.createRootSelectionPanel(this, getBcast);
        getBcast.findRoot();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            System.out.println("any thread interrupt when wait for FindRoot " + e.getMessage());
        }
    }

    public void sendWhereToConnect(ViewerInterface v) {
        this.rfb.setConnectionParam(this);
        TreeVncProtocol echo = new TreeVncProtocol(this.hostName, this.portNumber);
        echo.whereToConnect(this.myHostName, this.rfb.getAcceptPort());
    }

    public synchronized void setHostName(String _hostName, int port, String _myHostName) {
        this.hostName = _hostName;
        this.portNumber = port;
        this.myHostName = _myHostName;
        this.notify();
    }

    public void setHostName(String hostAndPort) {
        int i = hostAndPort.indexOf(58);
        if (i > 0) {
            this.portNumber = Integer.parseInt(hostAndPort.substring(i + 1));
            this.hostName = hostAndPort.substring(0, i);
        } else {
            this.hostName = hostAndPort;
        }
    }

    public String getMyHostName() {
        return this.myHostName;
    }

    public int getPort() {
        return this.portNumber;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setRootMode() {
        this.rootMode = true;
    }

    public boolean isRootMode() {
        return this.rootMode;
    }

    public void setDisplayMode() {
        this.displayMode = true;
    }

    public boolean isDisplayMode() {
        return this.displayMode;
    }

    public synchronized void restart() {
        this.notify();
    }
}

