/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;

public class MulticastQueue<T> {
    Node<T> tail = new Node<Object>(null);

    public ByteBuffer allocate(int size) {
        ByteBuffer b = null;
        while (true) {
            try {
                b = ByteBuffer.allocate(size);
            }
            catch (OutOfMemoryError e) {
                b = null;
                System.err.println("multicastqueue : wait for heap : " + e);
            }
            if (b != null) break;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                System.out.println("thread has interrupted the current thread.");
            }
        }
        return b;
    }

    public synchronized void heapAvailable() {
        this.notifyAll();
    }

    public synchronized void put(T item) {
        Node<T> next = new Node<T>(item);
        this.tail.set(next);
        this.tail = next;
    }

    public Client<T> newClient() {
        return new Client<T>(this.tail);
    }

    static class Node<T> {
        private T item;
        private Node<T> next;
        private CountDownLatch latch;

        public Node(T item) {
            this.item = item;
            this.next = null;
            this.latch = new CountDownLatch(1);
        }

        public T getItem() {
            return this.item;
        }

        public void set(Node<T> next) {
            this.next = next;
            this.latch.countDown();
        }

        public Node<T> next() throws InterruptedException {
            this.latch.await();
            return this.next;
        }

        public void clear() {
            this.item = null;
        }
    }

    public static class Client<T> {
        Node<T> node;

        Client(Node<T> tail) {
            this.node = tail;
        }

        public T poll() {
            Node<T> next = null;
            T item = null;
            do {
                try {
                    next = this.node.next();
                }
                catch (InterruptedException _e) {
                    System.out.println("thread has interrupted the current thread.");
                    continue;
                }
                item = next.getItem();
                this.node = next;
            } while (item == null);
            return item;
        }
    }
}

