/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import java.io.ByteArrayInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class ReceiveSound
implements Runnable {
    public static final int DEFAULT_SOUND_RECEIVE_PORT = 60004;
    public static final int recvPort = 60004;
    private DatagramSocket socket;
    private boolean isStop;

    public ReceiveSound(DatagramSocket socket) throws UnknownHostException, SocketException {
        this.socket = socket;
        this.isStop = false;
    }

    @Override
    public void run() {
        try {
            byte[] buffer = new byte[172];
            byte[] linearBuffer = new byte[320];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            AudioFormat ulawFormat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, false);
            AudioFormat linearFormat = new AudioFormat(8000.0f, 16, 1, true, false);
            AudioInputStream ulawStream = null;
            AudioInputStream linearStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, linearFormat);
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(linearFormat);
            sourceDataLine.start();
            while (!this.isStop) {
                try {
                    this.socket.receive(packet);
                    byteArrayInputStream = new ByteArrayInputStream(packet.getData(), 12, 160);
                    ulawStream = new AudioInputStream(byteArrayInputStream, ulawFormat, 160L);
                    linearStream = AudioSystem.getAudioInputStream(linearFormat, ulawStream);
                    linearStream.read(linearBuffer, 0, linearBuffer.length);
                    sourceDataLine.write(linearBuffer, 0, linearBuffer.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sourceDataLine.stop();
            sourceDataLine.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void recvStop() {
        this.isStop = true;
    }
}

