/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.transport.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ScreenChangeRequest
implements ClientToServerMessage {
    final String bytes;
    private final int scale;
    private final int x;
    private final int y;
    private short id;
    private int frameSizeWidth;
    private int frameSizeHeight;
    private int port;

    public ScreenChangeRequest(String adr, int port, short id, int x, int y, int width, int height, int scale) {
        this.bytes = adr;
        this.port = port;
        this.id = id;
        this.x = x;
        this.y = y;
        this.frameSizeWidth = width;
        this.frameSizeHeight = height;
        this.scale = scale;
        System.out.println("Client send change screen server request :" + adr);
    }

    @Override
    public void send(Writer writer) throws TransportException {
        ByteBuffer out = ByteBuffer.allocate(this.bytes.length() + 37);
        out.order(ByteOrder.BIG_ENDIAN);
        out.put((byte)-16);
        out.put((byte)0);
        out.putShort(this.id);
        out.putInt(this.bytes.length());
        out.put(this.bytes.getBytes());
        out.putInt(this.x);
        out.putInt(this.y);
        out.putInt(this.frameSizeWidth);
        out.putInt(this.frameSizeHeight);
        out.putInt(this.port);
        out.putInt(this.scale);
        writer.write(out.array(), 0, out.position());
        writer.flush();
    }

    public String toString() {
        return "Screen change request: [length: " + this.bytes.length() + ", text: ...]" + new String(this.bytes) + " : " + this.port;
    }
}

