/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class SendSound
implements Runnable {
    public static final int recvPort = 60004;
    private TreeRFBProto rfb;
    private DatagramSocket socket;
    private boolean isStop;
    private int sequenceNum;
    private int timeStamp;
    private int syncSourceId;
    private byte marker;
    private String destIp;
    private String destPort;

    public SendSound(DatagramSocket socket, TreeRFBProto rfb) {
        this.rfb = rfb;
        this.socket = socket;
    }

    public SendSound(DatagramSocket socket, TreeRFBProto rfb, String destIp, String destPort) throws UnknownHostException, SocketException {
        this.rfb = rfb;
        this.socket = socket;
        this.destIp = destIp;
        this.destPort = destPort;
        this.isStop = false;
    }

    @Override
    public void run() {
        try {
            byte[] rtpPacket;
            byte[] soundPacket = new byte[160];
            AudioFormat linearFormat = new AudioFormat(8000.0f, 16, 1, true, false);
            AudioFormat ulawFormat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, linearFormat);
            TargetDataLine targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(linearFormat);
            targetDataLine.start();
            AudioInputStream linearStream = new AudioInputStream(targetDataLine);
            AudioInputStream ulawStream = AudioSystem.getAudioInputStream(ulawFormat, linearStream);
            DatagramPacket packet = null;
            InetSocketAddress address = null;
            if (!this.rfb.isTreeManager()) {
                rtpPacket = new byte[172];
                address = new InetSocketAddress(this.destIp, Integer.parseInt(this.destPort));
            }
            while (!this.isStop) {
                try {
                    ulawStream.read(soundPacket, 0, soundPacket.length);
                    if (this.rfb.isTreeManager()) {
                        return;
                    }
                    rtpPacket = this.addRtpHeader(soundPacket);
                    packet = new DatagramPacket(rtpPacket, rtpPacket.length, address);
                    this.socket.send(packet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopSendSound() {
        this.isStop = true;
    }

    private byte[] addRtpHeader(byte[] voiceData) {
        byte[] rtpHeader = new byte[12];
        int version = -128;
        int padding = 0;
        int extention = 0;
        int contribute = 0;
        byte payload = 0;
        rtpHeader[0] = (byte)(version | padding | extention | contribute);
        rtpHeader[1] = (byte)(this.marker | payload);
        rtpHeader[2] = (byte)(this.sequenceNum >> 8);
        rtpHeader[3] = (byte)(this.sequenceNum >> 0);
        rtpHeader[4] = (byte)(this.timeStamp >> 24);
        rtpHeader[5] = (byte)(this.timeStamp >> 16);
        rtpHeader[6] = (byte)(this.timeStamp >> 8);
        rtpHeader[7] = (byte)(this.timeStamp >> 0);
        rtpHeader[8] = (byte)(this.syncSourceId >> 24);
        rtpHeader[9] = (byte)(this.syncSourceId >> 16);
        rtpHeader[10] = (byte)(this.syncSourceId >> 8);
        rtpHeader[11] = (byte)(this.syncSourceId >> 0);
        ++this.sequenceNum;
        this.timeStamp += 160;
        if (this.marker == -128) {
            this.marker = 0;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(172);
        out.write(rtpHeader, 0, 12);
        out.write(voiceData, 0, 160);
        return out.toByteArray();
    }
}

