/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import jp.ac.u_ryukyu.treevnc.TreeVNCNode;
import jp.ac.u_ryukyu.treevnc.TreeVncProtocol;

public class TreeManagement {
    private final int treeId;
    public LinkedList<TreeVNCNode> nodeList = new LinkedList();
    public LinkedList<NetworkAddress> treeAddresses = new LinkedList();
    private final int treebranch = 2;
    private boolean showTreeNode = false;
    public final int MAX_TREE = 15;
    public final int MAX_TREE_NODE = 4095;

    public TreeManagement(String hostName, int vncport, boolean showTree, int id) {
        this.treeId = id;
        TreeVNCNode me = new TreeVNCNode(hostName, vncport, "localhost");
        this.showTreeNode = showTree;
        me.setTreeNum(0);
        this.nodeList.add(me);
    }

    public int getTreeId() {
        return this.treeId;
    }

    public void moveLastNodeToLostNodePosition(int nodeNum) {
        this.nodeList.remove(nodeNum);
        if (nodeNum != this.nodeList.size()) {
            TreeVNCNode node = this.nodeList.removeLast();
            node.setTreeNum(nodeNum);
            this.nodeList.add(nodeNum, node);
        }
    }

    private void checkParameter(int parent, int counter, int leaderflag2) {
        System.out.print("number p =" + parent);
        System.out.print(" number i =" + counter);
        System.out.println(" leaderflag=" + leaderflag2 + "\n");
    }

    private TreeVNCNode getParentNode(int nodeNum) {
        int parentnum = (nodeNum - 1) / 2;
        return this.nodeList.get(parentnum);
    }

    public TreeVNCNode getChildNode(TreeVNCNode newparent, int i) {
        int child = newparent.getTreeNum() * 2 + i + 1;
        if (child >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(child);
    }

    public void fixLostParent(String hostname, int port, String myHostName) {
        TreeVNCNode lostParentNode = this.lookup(this.nodeList, hostname, port);
        if (lostParentNode == null) {
            return;
        }
        int treeNumber = lostParentNode.getTreeNum();
        TreeVNCNode deadParent = this.getParentNode(treeNumber);
        TreeVNCNode me = this.nodeList.getFirst();
        me.setHostName(myHostName);
        if (deadParent.getTreeNum() == 0) {
            try {
                this.connectTo(me, lostParentNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.getChildNode(deadParent, 0) == null) {
            return;
        }
        this.moveLastNodeToLostNodePosition(deadParent.getTreeNum());
        this.lostNodeConnection(deadParent);
    }

    public void fixLostChild(String hostname, int port, String myHostName, int clientId) {
        TreeVNCNode lostChildNode = this.lookup(this.nodeList, hostname, port);
        if (lostChildNode == null) {
            return;
        }
        int lostChildNodeNum = lostChildNode.getTreeNum() == 0 ? clientId + 1 : lostChildNode.getTreeNum() * 2 + clientId + 1;
        this.fixLostChild1(lostChildNodeNum);
    }

    public void fixLostChild1(int nodeNum) {
        TreeVNCNode deadNode;
        try {
            deadNode = this.nodeList.get(nodeNum);
        }
        catch (IndexOutOfBoundsException e) {
            deadNode = null;
        }
        if (deadNode != null) {
            this.moveLastNodeToLostNodePosition(deadNode.getTreeNum());
            this.lostNodeConnection(deadNode);
        }
        if (this.showTreeNode) {
            this.showTreeNode();
        }
    }

    public void lostNodeConnection(TreeVNCNode deadNode) {
        if (this.nodeList.size() < deadNode.getTreeNum() + 1) {
            return;
        }
        TreeVNCNode newNode = this.nodeList.get(deadNode.getTreeNum());
        TreeVNCNode parentNode = this.getParentNode(newNode.getTreeNum());
        try {
            this.connectTo(parentNode, newNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 2; ++i) {
            TreeVNCNode child = this.getChildNode(newNode, i);
            if (child == null) continue;
            try {
                this.connectTo(newNode, child);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void connectTo(TreeVNCNode newparent, TreeVNCNode n) throws IOException {
        TreeVncProtocol vc1 = new TreeVncProtocol(n.getHostname(), n.getPort());
        short nodeId = (short)n.getId();
        vc1.connectTo(newparent.getHostname(), newparent.getPort(), this.isLeader(n), nodeId);
    }

    private int isLeader(TreeVNCNode n) {
        return n.getTreeNum() % 2 == 1 ? 1 : 0;
    }

    private TreeVNCNode lookup(LinkedList<TreeVNCNode> list, String hostname, int port) {
        for (TreeVNCNode r : list) {
            if (!r.getHostname().equals(hostname) || r.getPort() != port) continue;
            return r;
        }
        return null;
    }

    public void decideWhereToConnect(String hostname, int port, String localhostname, int id) {
        TreeVNCNode node = new TreeVNCNode(hostname, port, localhostname);
        node.setTreeNum(this.nodeList.size());
        node.setId(id);
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            System.out.println("root : whereToConnect : cannot get ipAddress" + hostname);
            return;
        }
        if (this.onTheSameNetwork(ipAddress)) {
            this.nodeList.add(node);
        }
        if (this.nodeList.size() >= 3) {
            TreeVNCNode parent = this.getParentNode(node.getTreeNum());
            this.checkParameter(parent.getTreeNum(), this.nodeList.size(), this.isLeader(node));
            try {
                this.connectTo(parent, node);
            }
            catch (IOException e) {
                this.nodeList.remove(node);
                System.out.println("root : whereToConnect : Connection Faild" + hostname);
                return;
            }
        }
        TreeVNCNode me = this.nodeList.getFirst();
        me.setHostName(localhostname);
        try {
            this.connectTo(me, node);
        }
        catch (IOException e) {
            this.nodeList.remove(node);
            System.out.println("root : whereToConnect : Connection Faild" + hostname);
            return;
        }
        if (this.showTreeNode) {
            this.showTreeNode();
        }
    }

    public void showTreeNode() {
        int nl = 0;
        int pow = 2;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            TreeVNCNode treeNode = this.nodeList.get(i);
            System.out.print(treeNode.getTreeNum() + ":" + treeNode.getPort() + ":" + treeNode.getHostname());
            if (i == nl) {
                System.out.println();
                nl += pow;
                pow *= pow;
                continue;
            }
            System.out.print(" ");
        }
        System.out.println();
    }

    public LinkedList<TreeVNCNode> getList() {
        return this.nodeList;
    }

    public void setList(LinkedList<TreeVNCNode> _ls) {
        this.nodeList = _ls;
    }

    public int getTreeBranch() {
        return 2;
    }

    public void setNetMask(byte[] netmask, byte[] netaddress, InetAddress ipaddress) {
        this.treeAddresses.add(new NetworkAddress(ipaddress, netaddress, netmask));
    }

    public boolean onTheSameNetwork(InetAddress adr) {
        byte[] byteadr = adr.getAddress();
        for (NetworkAddress n : this.treeAddresses) {
            int i;
            byte[] netmask = n.netmask;
            byte[] netaddress = n.address;
            if (byteadr.length != netmask.length) continue;
            for (i = 0; i < netmask.length && (netmask[i] & byteadr[i]) == netaddress[i]; ++i) {
            }
            if (i < netmask.length) continue;
            return true;
        }
        return false;
    }

    private class NetworkAddress {
        InetAddress inetaddress;
        byte[] address;
        byte[] netmask;

        public NetworkAddress(InetAddress ipaddress, byte[] netaddress, byte[] netmask) {
            this.inetaddress = ipaddress;
            this.address = netaddress;
            this.netmask = netmask;
        }
    }
}

