/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.ViewerInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import jp.ac.u_ryukyu.treevnc.ChangeDesktopSize;
import jp.ac.u_ryukyu.treevnc.CheckDelay;
import jp.ac.u_ryukyu.treevnc.ChildNodeAnnounce;
import jp.ac.u_ryukyu.treevnc.CreateConnectionParam;
import jp.ac.u_ryukyu.treevnc.FindRoot;
import jp.ac.u_ryukyu.treevnc.MulticastQueue;
import jp.ac.u_ryukyu.treevnc.ReceiveSound;
import jp.ac.u_ryukyu.treevnc.ScreenChangeRequest;
import jp.ac.u_ryukyu.treevnc.TreeManagement;
import jp.ac.u_ryukyu.treevnc.TreeRootFinderListener;
import jp.ac.u_ryukyu.treevnc.TreeVNCNetwork;
import jp.ac.u_ryukyu.treevnc.TreeVNCNode;
import jp.ac.u_ryukyu.treevnc.TreeVncCommandChannelListener;
import jp.ac.u_ryukyu.treevnc.TreeVncProtocol;
import jp.ac.u_ryukyu.treevnc.TreeVncRootSelectionPanel;

public class TreeRFBProto {
    static final int CheckDelay = 11;
    protected static final int FramebufferUpdate = 0;
    protected ProtocolContext context;
    private int clients = 0;
    public MulticastQueue<LinkedList<ByteBuffer>> multicastqueue = new MulticastQueue();
    public int acceptPort = 0;
    private String myAddress;
    private long counter = 0L;
    public ServerSocket servSock;
    private static final int INFLATE_BUFSIZE = 102400;
    private Inflater inflater = new Inflater();
    private Deflater deflater = new Deflater();
    ViewerInterface viewer;
    private short id = 0;
    private short sharingId = (short)-1;
    private TreeVncCommandChannelListener acceptThread;
    private TreeRootFinderListener getCast;
    private CreateConnectionParam cp;
    private ConnectionPresenter connectionPresenter;
    private TreeVNCNetwork nets = new TreeVNCNetwork();
    private TreeVncRootSelectionPanel rootSelectionPanel;
    private String vncInterface;
    private TreeManagement treeManager;
    public LinkedList<TreeVNCNode> nodeList;
    protected boolean readyReconnect = false;
    private boolean cuiVersion;
    private boolean permitChangeScreen = true;
    private boolean leader;
    private boolean hasViewer = false;
    private boolean normalTermination;
    private boolean isTreeManager;
    public boolean showTreeNode = false;
    public boolean checkDelay = false;
    public boolean addSerialNum = false;
    public boolean fixingSize = false;
    public int fixingSizeWidth;
    public int fixingSizeHeight;
    private DatagramSocket socket = null;
    private byte[] originalInitData = null;
    private boolean childrenMulticast = true;
    private static int uniqueNodeId = 0;

    public TreeRFBProto(boolean isTreeManager, ViewerInterface viewer) {
        this.nets.setMyRfb(this);
        this.isTreeManager = isTreeManager;
        this.viewer = viewer;
        this.startTreeRootFindThread();
    }

    public void startTreeRootFindThread() {
        if (this.isTreeManager()) {
            this.getCast = new TreeRootFinderListener(this.viewer);
            Thread treeRootFindThread = new Thread((Runnable)this.getCast, "tree-root-find-listener");
            treeRootFindThread.start();
        }
    }

    public boolean isTreeManager() {
        return this.isTreeManager;
    }

    public void setIsTreeManager(boolean isTreeManager) {
        this.isTreeManager = isTreeManager;
    }

    public boolean isAddSerialNum() {
        return this.addSerialNum;
    }

    public ProtocolContext getContext() {
        return this.context;
    }

    public void newClient(final Writer os, final Reader is, final String intf) {
        final int myId = this.clients++;
        final MulticastQueue.Client<LinkedList<ByteBuffer>> c = this.multicastqueue.newClient();
        final AtomicInteger writerRunning = new AtomicInteger();
        writerRunning.set(1);
        Runnable timer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int count = 0;
                while (true) {
                    long timeout = 6250L;
                    try {
                        1 var4_3 = this;
                        synchronized (var4_3) {
                            int state;
                            writerRunning.set(0);
                            this.wait(timeout);
                            boolean flag = false;
                            while ((state = writerRunning.get()) == 0) {
                                c.poll();
                                ++count;
                                if (!flag) {
                                    flag = true;
                                }
                                this.wait(10L);
                            }
                            if (state != 1) {
                                System.out.println("Client died " + myId);
                                String rootHostName = null;
                                int rootHostPort = 0;
                                String myHostName = null;
                                int myHostPort = 0;
                                TreeRFBProto.this.clients = myId;
                                if (!TreeRFBProto.this.isTreeManager) {
                                    rootHostName = TreeRFBProto.this.getConnectionParam().getHostName();
                                    rootHostPort = TreeRFBProto.this.getConnectionParam().getPort();
                                    myHostName = TreeRFBProto.this.getMyAddress();
                                    myHostPort = TreeRFBProto.this.getAcceptPort();
                                    TreeVncProtocol echo = new TreeVncProtocol(rootHostName, rootHostPort);
                                    echo.lostChild(myHostName, myHostPort, myId);
                                } else {
                                    TreeRFBProto.this.getTreeManager(intf).fixLostChild1(myId + 1);
                                }
                                break;
                            }
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        System.out.println("timer thread interrupted.");
                        continue;
                    }
                    break;
                }
            }
        };
        new Thread(timer, "timer-discard-multicastqueue").start();
        final Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        byte[] b;
                        int c;
                        if ((c = is.readByte(b = new byte[4096])) <= 0) {
                            throw new IOException();
                        }
                        if (TreeRFBProto.this.isTreeManager()) {
                            ByteBuffer buf;
                            if (b[0] == -16) {
                                if (!TreeRFBProto.this.permitChangeScreen()) continue;
                                buf = ByteBuffer.wrap(b);
                                buf.order(ByteOrder.BIG_ENDIAN);
                                buf.get();
                                buf.get();
                                short id = buf.getShort();
                                int length = buf.getInt();
                                if (length == 0) continue;
                                byte[] byteAddress = new byte[length];
                                buf.get(byteAddress);
                                String newHostName = new String(byteAddress, "UTF-8");
                                int x = buf.getInt();
                                int y = buf.getInt();
                                int singleWidth = buf.getInt();
                                int singleHeight = buf.getInt();
                                int port = buf.getInt();
                                int scale = buf.getInt();
                                System.out.println("Root server change request :" + newHostName + " : " + port + " id:" + id);
                                TreeRFBProto.this.changeVNCServer(TreeRFBProto.this.viewer, newHostName, port, x, y, singleWidth, singleHeight, scale, id, is, os);
                                continue;
                            }
                            if (b[0] == 72) {
                                int rtpPort = TreeRFBProto.this.selectPort(60004);
                                InetAddress hostname = InetAddress.getLocalHost();
                                ReceiveSound receiveSound = new ReceiveSound(TreeRFBProto.this.socket);
                                Thread receiveSoundThread = new Thread((Runnable)receiveSound, "receive-sound");
                                receiveSoundThread.start();
                                continue;
                            }
                            if (b[0] != 70) continue;
                            buf = ByteBuffer.wrap(b);
                            buf.order(ByteOrder.BIG_ENDIAN);
                            buf.getShort();
                            Long time = buf.getLong();
                            int port = buf.getInt();
                            int addressLength = buf.getInt();
                            int dataLen = buf.getInt();
                            byte[] byteAddress = new byte[addressLength];
                            buf.get(byteAddress);
                            String address = new String(byteAddress, "UTF-8");
                            int nodeNum = TreeRFBProto.this.getNodeNum(port, address);
                            if (nodeNum == 0) continue;
                            Long delay = System.currentTimeMillis() - time;
                            if (delay > 3000L) {
                                TreeRFBProto.this.getTreeManager(intf).fixLostChild1(nodeNum);
                            }
                            System.out.println(System.currentTimeMillis() + " : receive checkDelay : nodeNum" + nodeNum + ", port : " + port + ", address : " + address + ", delay : " + delay + ", size : " + dataLen);
                            continue;
                        }
                        if (b[0] == -16) {
                            ClientToServerMessage serverChangeRequest = new ClientToServerMessage(){

                                @Override
                                public void send(Writer writer) throws TransportException {
                                    writer.write(b, 0, c);
                                }
                            };
                            TreeRFBProto.this.context.sendMessage(serverChangeRequest);
                            continue;
                        }
                        if (b[0] == 72) {
                            ClientToServerMessage readyShareSound = new ClientToServerMessage(){

                                @Override
                                public void send(Writer writer) throws TransportException {
                                    writer.write(b, 0, c);
                                }
                            };
                            TreeRFBProto.this.context.sendMessage(readyShareSound);
                            continue;
                        }
                        if (b[0] != 70) continue;
                        ClientToServerMessage checkDelayReply = new ClientToServerMessage(){

                            @Override
                            public void send(Writer writer) throws TransportException {
                                writer.write(b, 0, c);
                            }
                        };
                        TreeRFBProto.this.context.sendMessage(checkDelayReply);
                    }
                }
                catch (Exception e) {
                    try {
                        writerRunning.set(2);
                        os.close();
                        is.close();
                    }
                    catch (Exception e1) {
                        System.out.println("cannot close ClientToServerMessage " + e1);
                        System.out.println("cannot read ClientToServerMessage " + e);
                        return;
                    }
                    return;
                }
            }
        };
        Runnable sender = new Runnable(){

            @Override
            public void run() {
                writerRunning.set(1);
                try {
                    TreeRFBProto.this.requestThreadNotify();
                    new Thread(reader, "upward-packet-processing").start();
                    while (true) {
                        LinkedList flag;
                        int inputIndex;
                        LinkedList bufs;
                        ByteBuffer header;
                        if ((header = (ByteBuffer)(bufs = (LinkedList)c.poll()).get(inputIndex = 0)) == null) {
                            continue;
                        }
                        this.writeToClient(os, bufs, inputIndex);
                        writerRunning.set(1);
                        if (TreeRFBProto.this.childrenMulticast) continue;
                        while ((flag = (LinkedList)c.poll()).size() != 0) {
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        writerRunning.set(2);
                        os.close();
                    }
                    catch (IOException e1) {
                        System.out.println("root writer close failed :" + e1);
                    }
                    System.out.println("root writer failed :" + e);
                    return;
                }
            }

            public void writeToClient(Writer os2, LinkedList<ByteBuffer> bufs, int inputIndex) throws TransportException {
                while (inputIndex < bufs.size()) {
                    ByteBuffer b = bufs.get(inputIndex++);
                    os2.write(b.array(), b.position(), b.limit());
                }
                os2.flush();
                TreeRFBProto.this.multicastqueue.heapAvailable();
            }
        };
        new Thread(sender, "writer-to-lower-node").start();
    }

    public boolean permitChangeScreen() {
        return this.permitChangeScreen;
    }

    public void setPermitChangeScreen(boolean v) {
        this.permitChangeScreen = v;
    }

    public void requestThreadNotify() {
    }

    public void setProtocolContext(Protocol workingProtocol) {
        this.context = workingProtocol;
    }

    public Socket accept() throws IOException {
        return this.servSock.accept();
    }

    public int selectPort(int p) {
        int port = p;
        while (true) {
            try {
                this.servSock = new ServerSocket(port);
                this.acceptPort = port;
                this.myAddress = "127.0.0.1";
                this.nets.getNetworkInterfaces();
            }
            catch (BindException e) {
                ++port;
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        System.out.println("accept port = " + port);
        return port;
    }

    public void setViewer(ViewerInterface v) {
        this.viewer = v;
    }

    public ViewerInterface getViewer() {
        return this.viewer;
    }

    void sendInitData(OutputStream os) throws IOException {
        os.write(this.context.getInitData());
    }

    public void setTerminationType(boolean setType) {
        this.normalTermination = setType;
    }

    public boolean getTerminationType() {
        return this.normalTermination;
    }

    public void addHostToSelectionPanel(int port, String hostname, String myHostName) {
        if (this.rootSelectionPanel != null) {
            this.rootSelectionPanel.checkBox(Integer.toString(port) + ":" + hostname + ":" + myHostName);
            this.rootSelectionPanel.visible();
        }
    }

    public void createRootSelectionPanel(CreateConnectionParam cp, FindRoot getBcast) {
        this.rootSelectionPanel = new TreeVncRootSelectionPanel(getBcast);
        this.rootSelectionPanel.setCp(cp);
        this.rootSelectionPanel.visible();
    }

    public void close() {
    }

    public int getAcceptPort() {
        return this.acceptPort;
    }

    public boolean getReadyReconnect() {
        return this.readyReconnect;
    }

    public boolean getCuiVersion() {
        return this.cuiVersion;
    }

    public void setCuiVersion(boolean flag) {
        this.cuiVersion = flag;
    }

    public void readCheckDelay(Reader reader) throws TransportException {
    }

    public synchronized void vncConnected(boolean ready) {
        this.enableChildrenTransmission();
        this.readyReconnect = ready;
        if (ready) {
            this.notifyAll();
        }
    }

    public void printNetworkInterface() {
        Socket vncSocket = this.viewer.getVNCSocket();
        NetworkInterface ni = this.nets.getInterface(vncSocket);
        if (ni != null) {
            this.vncInterface = ni.getName();
            System.out.print("VNCNetworkInterface :" + this.vncInterface);
            System.out.println();
        }
    }

    public void sendDesktopSizeChange(short id) {
        LinkedList<ByteBuffer> desktopSize = new LinkedList<ByteBuffer>();
        int singleWidth = this.connectionPresenter.getSingleWidth();
        int singleHeight = this.connectionPresenter.getSingleHeight();
        int x = this.connectionPresenter.getX();
        int y = this.connectionPresenter.getY();
        desktopSize.add(new ChangeDesktopSize(this.context.getFbWidth(), this.context.getFbHeight(), singleWidth, singleHeight, x, y, EncodingType.INIT_DATA, this.context.getInitData(), id).getMessage());
        if (this.addSerialNum) {
            this.addSerialNumber(desktopSize);
        }
        this.multicastqueue.put(desktopSize);
    }

    public byte[] createOriginalInitData(int singleWidth, int singleHeight, String remoteDesktopName) {
        TreeVncCommandChannelListener treeVncCommandChannelListener = new TreeVncCommandChannelListener(this, this.acceptPort);
        byte[] originalInitData = treeVncCommandChannelListener.createOriginalInitData(singleWidth, singleHeight, remoteDesktopName);
        return originalInitData;
    }

    public void addSerialNumber(LinkedList<ByteBuffer> bufs) {
        ByteBuffer serialNum = this.multicastqueue.allocate(12);
        serialNum.putInt(1);
        serialNum.putLong(this.counter++);
        serialNum.flip();
        bufs.addFirst(serialNum);
    }

    public void resetDecoder() {
        this.context.resetDecoder();
    }

    public void stopReceiverTask() {
        if (this.context != null) {
            this.context.cleanUpSession(null);
            this.context.getRfb().clearChildrenTransmission();
        }
        if (this.isTreeManager()) {
            this.inflater = new Inflater();
        }
    }

    public void clearChildrenTransmission() {
    }

    public void enableChildrenTransmission() {
        this.childrenMulticast = true;
    }

    public String getMyAddress() {
        return this.myAddress;
    }

    public int zip(Deflater deflater, LinkedList<ByteBuffer> inputs, int inputIndex, LinkedList<ByteBuffer> outputs) throws IOException {
        int len = 0;
        ByteBuffer c1 = this.multicastqueue.allocate(102400);
        while (inputIndex < inputs.size()) {
            ByteBuffer b1 = inputs.get(inputIndex++);
            deflater.setInput(b1.array(), b1.position(), b1.remaining());
            if (inputIndex == inputs.size()) {
                deflater.finish();
            }
            int len1 = 0;
            do {
                if ((len1 = deflater.deflate(c1.array(), c1.position(), c1.remaining())) <= 0) continue;
                len += len1;
                c1.position(c1.position() + len1);
                if (c1.remaining() != 0) continue;
                c1.flip();
                outputs.addLast(c1);
                c1 = this.multicastqueue.allocate(102400);
            } while (len1 > 0 || !deflater.needsInput());
        }
        if (c1.position() != 0) {
            c1.flip();
            outputs.addLast(c1);
        }
        deflater.reset();
        return len;
    }

    public int unzip(Inflater inflater, LinkedList<ByteBuffer> inputs, int inputIndex, byte[] bytes, int bufSize) throws DataFormatException {
        int position = 0;
        int limit = bytes.length;
        while (inputIndex < inputs.size()) {
            ByteBuffer input = inputs.get(inputIndex++);
            inflater.setInput(input.array(), input.position(), input.limit());
            do {
                int len0;
                if ((len0 = inflater.inflate(bytes, position, limit - position)) <= 0 || (position += len0) <= limit) continue;
                throw new DataFormatException();
            } while (!inflater.needsInput());
        }
        return position;
    }

    public void readSendData(int dataLen, Reader reader, byte[] bytes, FramebufferUpdateRectangle rect) throws TransportException, UnsupportedEncodingException {
        LinkedList<ByteBuffer> bufs = new LinkedList<ByteBuffer>();
        int BLOCKSIZE = 65536;
        int headerLen = rect.getEncodingType() == EncodingType.CHECK_DELAY ? 24 : 16;
        ByteBuffer header = this.multicastqueue.allocate(headerLen);
        ByteBuffer serial = this.multicastqueue.allocate(12);
        if (!this.isTreeManager() && this.addSerialNum) {
            reader.readBytes(serial.array(), 0, 12);
            serial.limit(12);
        }
        reader.mark(dataLen);
        reader.readBytes(header.array(), 0, headerLen);
        header.limit(headerLen);
        if (header.get(0) == 0) {
            int encoding = header.getInt(12);
            if (encoding == EncodingType.ZRLE.getId() || encoding == EncodingType.ZLIB.getId()) {
                ByteBuffer len = this.multicastqueue.allocate(4);
                reader.readBytes(len.array(), 0, 4);
                len.limit(4);
                ByteBuffer inputData = this.multicastqueue.allocate(dataLen - 20);
                reader.readBytes(inputData.array(), 0, inputData.capacity());
                inputData.limit(dataLen - 20);
                LinkedList<ByteBuffer> inputs = new LinkedList<ByteBuffer>();
                inputs.add(inputData);
                header.putInt(12, EncodingType.ZRLEE.getId());
                Deflater nDeflater = this.deflater;
                LinkedList<ByteBuffer> out = new LinkedList<ByteBuffer>();
                try {
                    this.unzip(this.inflater, inputs, 0, bytes, 102400);
                    out.add(ByteBuffer.wrap(bytes));
                    int len2 = this.zip(nDeflater, out, 0, bufs);
                    ByteBuffer blen = this.multicastqueue.allocate(4);
                    blen.putInt(len2);
                    blen.flip();
                    bufs.addFirst(blen);
                    if (this.checkDelay) {
                        bufs = this.createCheckDelayHeader(bufs, header);
                    } else {
                        bufs.addFirst(header);
                    }
                    if (this.addSerialNum) {
                        this.addSerialNumber(bufs);
                    }
                    this.multicastqueue.put(bufs);
                }
                catch (IOException e) {
                    throw new TransportException(e);
                }
                catch (DataFormatException e) {
                    throw new TransportException(e);
                }
                return;
            }
            bufs.add(header);
            if (this.addSerialNum) {
                this.addSerialNumber(bufs);
            }
            if (dataLen > headerLen) {
                ByteBuffer b = this.multicastqueue.allocate(dataLen - headerLen);
                reader.readBytes(b.array(), 0, dataLen - headerLen);
                b.limit(dataLen - headerLen);
                bufs.add(b);
            }
            this.multicastqueue.put(bufs);
            return;
        }
    }

    public LinkedList<ByteBuffer> createCheckDelayHeader(LinkedList<ByteBuffer> checkDelay, ByteBuffer header) {
        short x = header.getShort(4);
        short y = header.getShort(6);
        short width = header.getShort(8);
        short height = header.getShort(10);
        long time = System.currentTimeMillis();
        checkDelay.addFirst(new CheckDelay(x, y, width, height, time, EncodingType.CHECK_DELAY).getMessage());
        return checkDelay;
    }

    public void setId(short id) {
        this.id = id;
    }

    public short getId() {
        return this.id;
    }

    public void setMyAddress(String myHostName) {
        this.myAddress = myHostName;
    }

    public void setLeader(boolean leader) {
        this.leader = leader;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public void setTreeManager(String intf, TreeManagement clients) {
        this.nets.setTreeManager(intf, clients);
    }

    public TreeManagement getTreeManager(String intf) {
        this.treeManager = this.nets.getTreeManager(intf);
        this.nodeList = this.treeManager.getList();
        return this.treeManager;
    }

    public int getNewNodeId() {
        return ++uniqueNodeId;
    }

    public void changeVNCServer(ViewerInterface vncProxyService, String hostName, int port, int x, int y, int width, int height, int scale, short newVNCServerId, Reader is, Writer os) throws IOException {
        if (newVNCServerId == -1) {
            vncProxyService.changeToDirectConnectedServer(hostName, is, os, x, y, width, height, scale);
            return;
        }
        vncProxyService.inhelitClients(hostName, newVNCServerId, x, y, width, height, scale);
    }

    public void createConnectionAndStart(ViewerInterface v) {
        this.selectPort(5950);
        this.acceptThread = new TreeVncCommandChannelListener(this, this.getAcceptPort());
        Thread thread = new Thread((Runnable)this.acceptThread, "TreeVNC-accept");
        thread.start();
    }

    public TreeVncCommandChannelListener getAcceptThread() {
        return this.acceptThread;
    }

    public void setConnectionParam(CreateConnectionParam createConnectionParam) {
        this.cp = createConnectionParam;
    }

    public CreateConnectionParam getConnectionParam() {
        return this.cp;
    }

    public boolean hasViewer() {
        return this.hasViewer;
    }

    public void setHasViewer(boolean b) {
        this.hasViewer = b;
    }

    public void setShowTree(boolean showTree) {
        this.showTreeNode = showTree;
    }

    public void setCheckDelay(boolean checkDelay) {
        this.checkDelay = checkDelay;
    }

    public void setAddSerialNum(boolean addSerialNum) {
        this.addSerialNum = addSerialNum;
    }

    public int getNodeNum(int port, String address) {
        int nodeNum = 0;
        for (TreeVNCNode tvn : this.nodeList) {
            if (port != tvn.port || !address.equals(tvn.hostname)) continue;
            nodeNum = tvn.treeNum;
            return nodeNum;
        }
        return nodeNum;
    }

    public void setFixingSize(boolean fixingSize) {
        this.fixingSize = fixingSize;
    }

    public boolean hasParent() {
        return this.id != -1;
    }

    public void exchangeDirectConnectedServer(Reader previousReader, Writer previousWriter) {
        String adr = this.viewer.getRfb().getMyAddress();
        ConnectionPresenter cp1 = this.viewer.getConnectionPresenter();
        int scale = cp1.getRetinaScale();
        int singleWidth = cp1.getSingleWidth();
        int singleHeight = cp1.getSingleHeight();
        int x = cp1.getX();
        int y = cp1.getY();
        ScreenChangeRequest scr = new ScreenChangeRequest(adr, 5950, -1, x, y, singleWidth, singleHeight, scale);
        try {
            scr.send(previousWriter);
        }
        catch (TransportException e) {
            e.printStackTrace();
            return;
        }
    }

    public synchronized void newVNCConnection(Protocol workingProtocol, ConnectionPresenter connectionPresenter) {
        ProtocolContext previousContext = this.getContext();
        this.stopReceiverTask();
        this.setProtocolContext(workingProtocol);
        this.connectionPresenter = connectionPresenter;
        connectionPresenter.viewer.setConnectionPresenter(connectionPresenter);
        connectionPresenter.addModel("ConnectionParamsModel", connectionPresenter.getConnectionParams());
        if (previousContext != null && this.isTreeManager() && this.hasParent()) {
            Reader previousReader = previousContext.getReader();
            Writer writer = previousContext.getWriter();
        }
        this.enableChildrenTransmission();
        this.printNetworkInterface();
        System.out.println("newVNCConenction reconnectingId: " + connectionPresenter.getReconnectingId());
        if (this.isTreeManager()) {
            this.sharingId = connectionPresenter.getReconnectingId();
        }
        this.sendDesktopSizeChange(connectionPresenter.getReconnectingId());
    }

    public void sendErrorAnnounce(short reconnectingId, String message) {
        LinkedList<ByteBuffer> errorAnnounce = new LinkedList<ByteBuffer>();
        errorAnnounce.add(new ChildNodeAnnounce(EncodingType.ERROR_ANNOUNCE, message.getBytes(), reconnectingId).getMessage());
        if (this.addSerialNum) {
            this.addSerialNumber(errorAnnounce);
        }
        this.multicastqueue.put(errorAnnounce);
    }

    public void setConnectionPresenter(ConnectionPresenter connectionPresenter) {
        this.connectionPresenter = connectionPresenter;
    }

    public short getSharingId() {
        return this.sharingId;
    }

    public void setSharingId(short sharingId) {
        this.sharingId = sharingId;
    }
}

