/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.viewer.ViewerInterface;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import jp.ac.u_ryukyu.treevnc.TreeVncProtocol;

public class TreeRootFinderListener
implements Runnable {
    public static final String Ipv4McastAddr = "224.0.0.1";
    public static final String Ipv6McastAddr = "ff02::1";
    public static String McastAddr = "224.0.0.1";
    static final int BufSize = 1024;
    private boolean stopFlag = false;
    private ViewerInterface vps;
    private MulticastSocket soc;
    private SecurityManager securityManager;

    public TreeRootFinderListener(ViewerInterface vncProxyService) {
        this.vps = vncProxyService;
    }

    public static MulticastSocket createMulticastSocket() throws IOException {
        MulticastSocket soc = new MulticastSocket(5900);
        try {
            soc.joinGroup(InetAddress.getByName(McastAddr));
        }
        catch (SocketException e) {
            System.out.println("join to 224.0.0.1 failed.");
        }
        try {
            soc.joinGroup(InetAddress.getByName(Ipv6McastAddr));
        }
        catch (SocketException e) {
            System.out.println("join to ff02::1 failed.");
        }
        return soc;
    }

    private void replyToRootSearchMulticast() {
        byte[] buf = new byte[1024];
        try {
            this.soc = TreeRootFinderListener.createMulticastSocket();
            System.out.println("FindRoot listening on " + InetAddress.getByName(McastAddr));
            DatagramPacket recvPacket = new DatagramPacket(buf, 1024);
            while (!this.stopFlag) {
                this.soc.receive(recvPacket);
                String hostname = recvPacket.getAddress().getHostAddress();
                byte[] reply = recvPacket.getData();
                int len = recvPacket.getLength();
                if (len != 12 || (reply[0] & 0xFF) != ProtocolContext.TreeCommand.FIND_ROOT.cmd) continue;
                int port = reply[8];
                port = port * 256 + reply[9];
                port = port * 256 + reply[10];
                port = port * 256 + reply[11];
                TreeVncProtocol t = new TreeVncProtocol(hostname, port);
                t.findRootReply(this.vps.getRfb().getAcceptPort());
                if (!this.stopFlag) continue;
                break;
            }
        }
        catch (Exception e) {
            System.out.println("tree-root-find-listener :" + e.getMessage());
        }
    }

    @Override
    public void run() {
        this.replyToRootSearchMulticast();
    }

    public void setStopFlag(boolean stopFlag) {
        this.stopFlag = stopFlag;
    }

    public boolean isStopFlag() {
        return this.stopFlag;
    }
}

