/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import jp.ac.u_ryukyu.treevnc.TreeManagement;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class TreeVNCNetwork {
    private HashMap<String, TreeManagement> interfaces = new HashMap();
    private TreeRFBProto myRfb;
    private boolean useHostName = false;

    public TreeRFBProto getMyRfb() {
        return this.myRfb;
    }

    public void setMyRfb(TreeRFBProto myRfb) {
        this.myRfb = myRfb;
    }

    public void getNetworkInterfaces() throws SocketException {
        int treeId = 0;
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            if (!ni.isUp() || !ni.supportsMulticast() || ni.isLoopback()) continue;
            TreeManagement treeManager = new TreeManagement(ni.getDisplayName(), 5950, this.myRfb.getViewer().getShowTree(), treeId++);
            this.addNetworkInterface(ni, treeManager);
            for (InterfaceAddress ipaddress : ni.getInterfaceAddresses()) {
                byte[] netmask = this.getNetMask(ipaddress);
                String hostName = ipaddress.getAddress().toString();
                if (this.useHostName) {
                    hostName = ipaddress.getAddress().getHostName();
                }
                treeManager.getList().getFirst().setPort(this.myRfb.getAcceptPort());
                byte[] netaddr = ipaddress.getAddress().getAddress();
                for (int i = 0; i < netaddr.length; ++i) {
                    int n = i;
                    netaddr[n] = (byte)(netaddr[n] & netmask[i]);
                }
                treeManager.setNetMask(netmask, netaddr, ipaddress.getAddress());
                System.out.println("Interfaces :" + ni.getName() + " treeId=" + treeId + " " + hostName);
            }
        }
    }

    private byte[] getNetMask(InterfaceAddress ipaddress) {
        short prefix = ipaddress.getNetworkPrefixLength();
        byte[] netmask = ipaddress.getAddress().getAddress();
        for (int i = 0; i < netmask.length; ++i) {
            int bitpos = i * 8;
            if (bitpos + 7 < prefix) {
                netmask[i] = -1;
                continue;
            }
            if (bitpos < prefix) {
                int bytemask = 128;
                for (int j = 1; j < bitpos + 8 - prefix; ++j) {
                    bytemask >>= 1;
                    bytemask |= 0x80;
                }
                netmask[i] = (byte)bytemask;
                continue;
            }
            netmask[i] = 0;
        }
        return netmask;
    }

    NetworkInterface getInterface(Socket vncSocket) {
        InetAddress address = vncSocket.getInetAddress();
        try {
            return NetworkInterface.getByInetAddress(address);
        }
        catch (SocketException e) {
            return null;
        }
    }

    private void addNetworkInterface(NetworkInterface ni, TreeManagement treeManager) {
        this.setTreeManager(ni.getName(), treeManager);
    }

    public void setTreeManager(String intf, TreeManagement treeManager) {
        this.interfaces.put(intf, treeManager);
    }

    public TreeManagement getTreeManager(String intf) {
        return this.interfaces.get(intf);
    }
}

