/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import java.io.IOException;
import java.net.Socket;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;

public class TreeVncCommand {
    TreeRFBProto rfb;
    int port;
    String hostname;
    String myHostName;
    Writer os;
    Reader is;
    private ProtocolContext.TreeCommand command;
    private Socket connection;
    private short value;
    public String intf;

    public TreeVncCommand(TreeRFBProto rfb, String myHostName, ProtocolContext.TreeCommand command, int port, String hostname, String intf, short value) {
        this.rfb = rfb;
        this.myHostName = myHostName;
        this.hostname = hostname;
        this.port = port;
        this.intf = intf;
        this.command = command;
        this.value = value;
    }

    public TreeVncCommand(TreeRFBProto rfb, String myHostAddress, ProtocolContext.TreeCommand newNode, Writer os, Reader is, Socket connection, String intf) {
        this.rfb = rfb;
        this.myHostName = myHostAddress;
        this.command = newNode;
        this.os = os;
        this.is = is;
        this.connection = connection;
        this.intf = intf;
    }

    public void handleTreeVncCommand() {
        switch (this.command) {
            case FIND_ROOT_REPLY: {
                this.handleFindRootReply(this.port, this.hostname, this.myHostName);
                break;
            }
            case CONNECT_TO_AS_LEADER: {
                this.handleConnectTo(this.port, this.hostname, this.myHostName, true, this.value);
                break;
            }
            case CONNECT_TO: {
                this.handleConnectTo(this.port, this.hostname, this.myHostName, false, this.value);
                break;
            }
            case FIND_ROOT: {
                break;
            }
            case WHERE_TO_CONNECT: {
                this.handleWhereToConnect(this.port, this.hostname, this.myHostName);
                break;
            }
            case LOST_PARENT: {
                this.handleLostParent(this.port, this.hostname, this.myHostName);
                break;
            }
            case NEW_NODE: {
                this.rfb.newClient(this.os, this.is, this.intf);
                break;
            }
            case QUIT_LOOP: {
                break;
            }
            case LOST_CHILD: {
                this.handleLostChild(this.port, this.hostname, this.myHostName, this.value);
                break;
            }
            default: {
                System.out.println("unknown treeVNC command" + (Object)((Object)this.command));
            }
        }
    }

    void handleWhereToConnect(int port, String hostname, String myHostName) {
        int id = this.rfb.getNewNodeId();
        this.rfb.getTreeManager(this.intf).decideWhereToConnect(hostname, port, myHostName, id);
    }

    void handleConnectTo(int port, String hostname, String myHostName, boolean leader, short id) {
        this.rfb.stopReceiverTask();
        this.rfb.setId(id);
        this.rfb.setMyAddress(myHostName);
        this.rfb.setLeader(leader);
        if (this.rfb.isTreeManager()) {
            this.rfb.setId((short)-1);
        }
        try {
            this.rfb.getViewer().connectToParenet(port, hostname);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    void handleFindRootReply(int port, String hostname, String myHostname) {
        this.rfb.addHostToSelectionPanel(port, hostname, myHostname);
    }

    private void handleLostParent(int port, String hostname, String myHostName) {
        this.rfb.getTreeManager(this.intf).fixLostParent(hostname, port, myHostName);
    }

    public void handleLostChild(int port, String hostname, String myHostName, int clientId) {
        this.rfb.getTreeManager(this.intf).fixLostChild(hostname, port, myHostName, clientId);
    }

    public ProtocolContext.TreeCommand getCommand() {
        return this.command;
    }
}

