/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import jp.ac.u_ryukyu.treevnc.TreeRFBProto;
import jp.ac.u_ryukyu.treevnc.TreeVncCommand;

public class TreeVncCommandChannelListener
implements Runnable {
    public TreeRFBProto rfb = null;
    byte[] imageBytes;
    int port;
    LinkedBlockingQueue<TreeVncCommand> cmdQueue = new LinkedBlockingQueue();
    private Thread acceptThread;
    protected static final String versionMsg_3_856 = "RFB 003.856\n";

    public TreeVncCommandChannelListener(TreeRFBProto _rfb, int p) {
        this.rfb = _rfb;
        this.port = p;
    }

    public void commandMainLoop() {
        this.acceptThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TreeVncCommand cmd = null;
                do {
                    try {
                        cmd = TreeVncCommandChannelListener.this.cmdQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    if (cmd == null) continue;
                    cmd.handleTreeVncCommand();
                } while (cmd == null || cmd.getCommand() != ProtocolContext.TreeCommand.QUIT_LOOP);
            }
        }, "root-command-loop");
        this.acceptThread.start();
    }

    @Override
    public void run() {
        this.commandMainLoop();
        while (true) {
            try {
                while (true) {
                    final Socket newCli = this.rfb.accept();
                    final OutputStream os = newCli.getOutputStream();
                    final InputStream is = newCli.getInputStream();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            TreeVncCommand cmd = TreeVncCommandChannelListener.this.newClientHandler(newCli, new Writer(os), new Reader(is));
                            if (cmd != null) {
                                TreeVncCommandChannelListener.this.cmdQueue.add(cmd);
                            }
                        }
                    }, "accepting").start();
                }
            }
            catch (Exception e) {
                System.out.println("failed to connect incoming client" + e.getMessage());
                continue;
            }
            break;
        }
    }

    public TreeVncCommand newClientHandler(Socket newCli, Writer os, Reader is) {
        TreeVncCommand cmd = null;
        try {
            cmd = this.initialConnection(this.rfb, os, is, newCli);
            if (cmd != null && cmd.getCommand() != ProtocolContext.TreeCommand.NEW_NODE) {
                newCli.close();
                return cmd;
            }
        }
        catch (Exception e) {
            try {
                System.out.println("new client faild :" + e.getMessage());
                newCli.close();
                return null;
            }
            catch (IOException e1) {
                System.out.println("new client close faild");
                return null;
            }
        }
        return cmd;
    }

    public TreeVncCommand initialConnection(TreeRFBProto myRfbProto, Writer os, Reader is, Socket connection) throws IOException, TransportException {
        TreeVncCommand cmd;
        InetAddress adr = connection.getLocalAddress();
        String myHostAddress = adr.getHostAddress();
        String intf = NetworkInterface.getByInetAddress(adr).getName();
        this.sendRfbVersion(os);
        byte[] b = this.readVersionMsg(is, os);
        if (b != null && (cmd = this.treeVncCommand(b, is, os, myHostAddress, intf)) != null) {
            return cmd;
        }
        this.sendSecurityType(os);
        this.readSecType(is);
        this.sendSecResult(os);
        this.readClientInit(is);
        this.sendInitData(os);
        System.out.println("direct connection from " + connection.getInetAddress());
        return new TreeVncCommand(this.rfb, myHostAddress, ProtocolContext.TreeCommand.NEW_NODE, os, is, connection, intf);
    }

    TreeVncCommand treeVncCommand(byte[] b, Reader is, Writer os, String myHostName, String intf) throws TransportException, IOException {
        ByteBuffer buf = ByteBuffer.wrap(b);
        ProtocolContext.TreeCommand command = ProtocolContext.TreeCommand.create(buf.get() & 0xFF);
        buf.get();
        short value = buf.getShort();
        int length = buf.getInt();
        int port = buf.getInt();
        String hostname = null;
        if (length > 4) {
            if (length > 1024) {
                System.out.println("Too long TreeVncCommand ");
                return null;
            }
            byte[] namebuf = new byte[length - 4];
            try {
                is.readBytes(namebuf);
            }
            catch (TransportException e) {
                return null;
            }
            hostname = new String(namebuf);
        }
        return new TreeVncCommand(this.rfb, myHostName, command, port, hostname, intf, value);
    }

    void sendRfbVersion(Writer writer) throws IOException, TransportException {
        writer.write(versionMsg_3_856.getBytes());
    }

    byte[] readVersionMsg(Reader reader, Writer writer) throws IOException, TransportException {
        byte[] b = new byte[12];
        reader.readBytes(b);
        if ((b[0] & 0xFF) >= 220) {
            return b;
        }
        if (b[0] != 82 || b[1] != 70 || b[2] != 66 || b[3] != 32 || b[4] < 48 || b[4] > 57 || b[5] < 48 || b[5] > 57 || b[6] < 48 || b[6] > 57 || b[7] != 46 || b[8] < 48 || b[8] > 57 || b[9] < 48 || b[9] > 57 || b[10] < 48 || b[10] > 57 || b[11] != 10) {
            throw new IOException("this is not an RFB server");
        }
        int rfbMajor = (b[4] - 48) * 100 + (b[5] - 48) * 10 + (b[6] - 48);
        if (rfbMajor < 3) {
            throw new IOException("RFB server does not support protocol version 3");
        }
        return null;
    }

    void readSecType(Reader reader) throws TransportException {
        byte[] b = new byte[1];
        reader.read(b);
    }

    void sendSecurityType(Writer os) throws TransportException {
        os.writeInt(1);
        os.writeInt(1);
    }

    void sendSecResult(Writer os) throws TransportException {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putInt(0);
        os.write(b.array());
    }

    void readClientInit(Reader in) throws TransportException {
        byte[] b = new byte[]{};
        in.readBytes(b);
    }

    void sendInitData(Writer os) throws TransportException {
        ProtocolContext context = this.rfb.context;
        if (context != null) {
            os.write(context.getInitData());
        } else {
            byte[] dummyInitData = new byte[]{7, -128, 4, 56, 32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0, 0, 0, 0, 7, 103, 105, 114, 101, 102, 108, 121};
            os.write(dummyInitData);
        }
    }

    public byte[] createOriginalInitData(int width, int height, String desktopName) {
        byte[] titleBytes = null;
        int titleLength = 0;
        byte[] pixelFormat = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0, 0, 0, 0};
        try {
            titleBytes = desktopName.getBytes("UTF-8");
            titleLength = titleBytes.length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteBuffer initData = ByteBuffer.allocate(24 + titleLength);
        initData.putShort((short)width);
        initData.putShort((short)height);
        initData.put(pixelFormat);
        initData.put((byte)titleLength);
        initData.put(titleBytes);
        initData.flip();
        return initData.array();
    }

    public void waitForShutdown() {
        if (this.acceptThread != null) {
            try {
                this.acceptThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

