/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import com.glavsoft.rfb.protocol.ProtocolContext;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TreeVncProtocol {
    private BufferedReader is = null;
    private DataOutputStream os = null;
    private Socket echoSocket = null;
    private int rootPort;
    private String rootAddress;

    public TreeVncProtocol(String name, int echoPort) {
        this.rootPort = echoPort;
        this.rootAddress = name;
    }

    public void openport() throws IOException {
        this.echoSocket = new Socket(this.rootAddress, this.rootPort);
        this.os = new DataOutputStream(this.echoSocket.getOutputStream());
        this.is = new BufferedReader(new InputStreamReader(this.echoSocket.getInputStream()));
    }

    public void findRootReply(int port) {
        try {
            this.sendWithHostAndPort(ProtocolContext.TreeCommand.FIND_ROOT_REPLY, null, port, (short)0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("cannot send findRootReplay");
        }
    }

    public void whereToConnect(String hostname, int port) {
        try {
            this.sendWithHostAndPort(ProtocolContext.TreeCommand.WHERE_TO_CONNECT, hostname, port, (short)0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("cannot send whereToConnect");
        }
    }

    public void connectTo(String hostname, int port, int leaderFlag, short yourId) throws IOException {
        ProtocolContext.TreeCommand command = leaderFlag == 1 ? ProtocolContext.TreeCommand.CONNECT_TO_AS_LEADER : ProtocolContext.TreeCommand.CONNECT_TO;
        this.sendWithHostAndPort(command, hostname, port, yourId);
    }

    public void lostParent(String hostname, int port) {
        try {
            this.sendWithHostAndPort(ProtocolContext.TreeCommand.LOST_PARENT, hostname, port, (short)0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("cannot send lostParent");
        }
    }

    public void lostChild(String myHostName, int myHostPort, int myId) {
        try {
            this.sendWithHostAndPort(ProtocolContext.TreeCommand.LOST_CHILD, myHostName, myHostPort, (short)myId);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("cannot send lostChild");
        }
    }

    public void sendWithHostAndPort(ProtocolContext.TreeCommand command, String hostname, int port, short value) throws IOException {
        int cmdlen;
        this.openport();
        if (hostname == null) {
            hostname = this.echoSocket.getLocalAddress().getHostAddress();
        }
        if ((cmdlen = 12 + hostname.length()) < 12) {
            cmdlen = 12;
        }
        ByteBuffer buf = ByteBuffer.allocate(cmdlen);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)command.cmd);
        buf.put((byte)0);
        buf.putShort(value);
        buf.putInt(4 + hostname.length());
        buf.putInt(port);
        buf.put(hostname.getBytes(), 0, hostname.length());
        while (buf.hasRemaining()) {
            buf.put((byte)0);
        }
        buf.flip();
        this.sendCommandToTheRoot(buf);
    }

    public void sendCommandToTheRoot(ByteBuffer buf) throws IOException {
        char[] charBuf = new char[12];
        this.is.read(charBuf, 0, 12);
        this.os.write(buf.array(), 0, buf.limit());
    }

    void streamClose() throws IOException {
        this.os.close();
        this.is.close();
        this.echoSocket.close();
    }
}

