/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_ryukyu.treevnc;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.ac.u_ryukyu.treevnc.CreateConnectionParam;
import jp.ac.u_ryukyu.treevnc.FindRoot;

public class TreeVncRootSelectionPanel
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private final FindRoot findRoot;
    private JPanel panel = new JPanel();
    private JButton button = new JButton("Start");
    private JComboBox advancedMenu = new JComboBox();
    private TextField t1;
    private TextField t2;
    private double width = 750.0;
    private double height = 500.0;
    private JLabel label;
    private int counter = 0;
    private Checkbox[] check = new Checkbox[20];
    private String port;
    private CheckboxGroup ch = new CheckboxGroup();
    private Container contentPane = this.getContentPane();
    private CreateConnectionParam cp;

    public TreeVncRootSelectionPanel(FindRoot findRoot) {
        this.findRoot = findRoot;
        this.setTitle("TreeVNC Root Address");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setAdvancedMenu();
        this.setButton();
    }

    private void setAdvancedMenu() {
        this.advancedMenu.addItem("Connect to TreeVNC");
        this.advancedMenu.addItem("Start as TreeVNC Root");
        this.advancedMenu.addItem("Start Display Mode");
        this.panel.add(this.advancedMenu);
        this.contentPane.add((Component)this.panel, "Center");
    }

    public void ipRegister() {
        this.setSize();
        this.setText();
        this.setButton();
        this.visible();
    }

    private void setSize() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.width = d.getWidth() / 2.0;
        this.height = d.getHeight() / 2.0;
    }

    public void visible() {
        Point point = new Point();
        point.setLocation(this.width - 250.0, this.height - 80.0);
        this.setLocation(point.getLocation());
        this.pack();
        this.setVisible(true);
    }

    public void unVisible() {
        this.setVisible(false);
    }

    private void setText() {
        this.t1 = new TextField("Address", 30);
        this.t2 = new TextField(Integer.toString(5950), 5);
        this.panel.add(this.t1);
        this.panel.add(this.t2);
        this.label = new JLabel();
        this.contentPane.add((Component)this.panel, "Center");
        this.contentPane.add((Component)this.label, "South");
    }

    public void checkBox(String str) {
        this.check[this.counter] = this.counter == 0 ? new Checkbox(str, true, this.ch) : new Checkbox(str, false, this.ch);
        this.check[this.counter].addItemListener(this);
        this.panel.add(this.check[this.counter]);
        this.panel.setLayout(new GridLayout(this.counter + 2, 0));
        this.panel.setLocation((int)this.width - 250, (int)this.height - 80);
        ++this.counter;
    }

    public void setButton() {
        this.panel.add(this.button);
        this.button.addActionListener(this);
        this.contentPane.add((Component)this.panel, "Center");
    }

    public String getPortOption() {
        return this.t2.getText();
    }

    public String getPort() {
        return this.port;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.advancedMenu.getSelectedIndex() == 0) {
            for (int t = 0; t < this.counter; ++t) {
                int ipv4AddressLength = 3;
                int ipv6AddressLength = 17;
                String port = null;
                String hostAddress = null;
                String rootAddress = null;
                if (!this.check[t].getState()) continue;
                String str = this.check[t].getLabel();
                String[] temp = str.split(":");
                if (temp.length == ipv4AddressLength) {
                    port = temp[0];
                    hostAddress = temp[1];
                    rootAddress = temp[2];
                } else if (temp.length == ipv6AddressLength) {
                    port = temp[0];
                    hostAddress = temp[1] + ":" + temp[2] + ":" + temp[3] + ":" + temp[4] + ":" + temp[5] + ":" + temp[6] + ":" + temp[7] + ":" + temp[8];
                    rootAddress = temp[9] + ":" + temp[10] + ":" + temp[11] + ":" + temp[12] + ":" + temp[13] + ":" + temp[14] + ":" + temp[15] + ":" + temp[16];
                }
                this.cp.setHostName(hostAddress, Integer.parseInt(port), rootAddress);
                this.unVisible();
            }
        } else if (this.advancedMenu.getSelectedIndex() == 1) {
            this.cp.setRootMode();
            this.cp.restart();
            this.unVisible();
        } else if (this.advancedMenu.getSelectedIndex() == 2) {
            this.cp.setDisplayMode();
            this.cp.restart();
            this.unVisible();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public void setCp(CreateConnectionParam cp) {
        this.cp = cp;
    }
}

